package org.codehaus.xfire.java.types;

import org.codehaus.xfire.java.mapping.TypeMappingRegistry;
import org.codehaus.xfire.java.message.LiteralReader;
import org.codehaus.xfire.java.message.LiteralWriter;
import org.codehaus.xfire.java.test.SimpleBean;
import org.codehaus.xfire.java.type.ArrayType;
import org.codehaus.xfire.java.type.BeanType;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;

/**
 * TypeTest
 * 
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 */
public class TypeTest
    extends PlexusXFireTest
{
    public void testBeanType() throws Exception
    {
        TypeMappingRegistry tmr = (TypeMappingRegistry) lookup( TypeMappingRegistry.ROLE );
        
        SimpleBean bean = new SimpleBean();
        bean.setBleh("bleh");
        bean.setHowdy("howdy");
        
        registerSimpleBeanType(tmr);
        
        BeanType bt = (BeanType) tmr.getDefaultTypeMapping().getType( SimpleBean.class );
       
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        
        bt.writeObject( bean, new LiteralWriter(root) );
        
        SimpleBean readBean = (SimpleBean) bt.readObject( new LiteralReader(root) );
        assertNotNull( readBean );
        assertEquals( "bleh", readBean.getBleh() );
        assertEquals( "howdy", readBean.getHowdy() );
        
        System.out.println( doc.asXML() );
        
        doc = DocumentHelper.createDocument();
        
        root = doc.addElement("root");
        
        bt.writeSchema( root );
 
        // TODO: run XPath tests on Schema
    }
    
    /**
     * @param tmr
     * @return
     */
    private void registerSimpleBeanType(TypeMappingRegistry tmr)
    {
        tmr.getDefaultTypeMapping().register( SimpleBean.class, 
                                              QName.get( "SimpleBean", "urn:SimpleBean" ),
                                              BeanType.class );
    }

    private void registerArrayType(TypeMappingRegistry tmr)
    {
        tmr.getDefaultTypeMapping().register( SimpleBean[].class, 
                                              QName.get( "ArrayOfSimpleBean", "urn:SomeBean" ),
                                              ArrayType.class );
    }
    
    public void testArrayType() throws Exception
    {
        TypeMappingRegistry tmr = (TypeMappingRegistry) lookup( TypeMappingRegistry.ROLE );
        
        registerSimpleBeanType(tmr);
        registerArrayType( tmr );
        
        SimpleBean bean = new SimpleBean();
        bean.setBleh("bleh");
        bean.setHowdy("howdy");
       
        SimpleBean[] beanArray = new SimpleBean[] { bean, bean };

        ArrayType at = (ArrayType) tmr.getDefaultTypeMapping().getType( SimpleBean[].class );
  
        
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("root");
        
        at.writeObject( beanArray, new LiteralWriter( root ) );
        
        Object out1 = at.readObject( new LiteralReader( root ) );
        
        SimpleBean[] beans = (SimpleBean[]) out1;
        assertNotNull( beans );
        assertEquals( "bleh", beans[0].getBleh() );
        assertEquals( "howdy", beans[0].getHowdy() );
        
        System.out.println( doc.asXML() );
        
        doc = DocumentHelper.createDocument();
        
        root = doc.addElement("root");
        
        at.writeSchema( root );
        
        // TODO: run XPath tests on Schema
    }
}
