package org.codehaus.xfire.java.wrapped;

import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.test.TestHttpTransport;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class WrappedAutoTypeTest
    extends PlexusXFireTest
{
    public void testBeanService() throws Exception
    {
        Document response = 
            invokeService("Bean", "/org/codehaus/xfire/java/wrapped/bean11.xml");

        addNamespace( "root", "urn:Bean");
        addNamespace( "sb", "http://test.java.xfire.codehaus.org");
        assertValid( "//root:getSimpleBeanResponse", response );
        assertValid( "//root:getSimpleBeanResponse/sb:out", response );
        assertValid( "//root:getSimpleBeanResponse/sb:out/sb:howdy[text()=\"howdy\"]", response );
        assertValid( "//root:getSimpleBeanResponse/sb:out/sb:bleh[text()=\"bleh\"]", response );
    }

    public void testBeanServiceWSDL() throws Exception
    {
        TransportManager tm = (TransportManager) lookup( TransportManager.ROLE );
        tm.register( new TestHttpTransport() );
        
        Document doc = getWSDLDocument("Bean");
        
        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "wsdlsoap", WSDL.WSDL11_SOAP_NS );
        addNamespace( "xsd", SOAPConstants.XSD );

        assertValid( "/wsdl:definitions/wsdl:types", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema[@targetNamespace='urn:Bean']", doc );
        assertValid( "//xsd:schema[@targetNamespace='urn:Bean']/xsd:element[@name='getSubmitBean']", doc );
        assertValid( "//xsd:element[@name='getSubmitBean']/xsd:complexType/xsd:sequence/xsd:element[@name='in1'][@type='xsd:string']", doc );
        assertValid( "//xsd:element[@name='getSubmitBean']/xsd:complexType/xsd:sequence/xsd:element[@name='in0'][@type='ns1:SimpleBean']", doc );

        assertNotNull( doc.getRootElement().getNamespaceForPrefix("ns1") );
        
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@name=\"bleh\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@name=\"howdy\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types" +
                "/xsd:schema[@targetNamespace='http://test.java.xfire.codehaus.org']" +
                "/xsd:complexType[@name=\"SimpleBean\"]/xsd:sequence/xsd:element[@type=\"xsd:string\"]", doc );

        assertValid( "/wsdl:definitions/wsdl:service/wsdl:port/wsdlsoap:address[@location='http://localhost/services/Bean']", doc );
    }
    
    public void testArrayService() throws Exception
    {
        Document response = invokeService("Array", 
                "/org/codehaus/xfire/java/wrapped/SubmitStringArray11.xml");

        addNamespace( "a", "urn:Array");
        addNamespace( "sb", "http://test.java.xfire.codehaus.org");
        assertValid( "//a:SubmitStringArrayResponse", response );
        assertValid( "//a:SubmitStringArrayResponse/a:out[text()='true']", response );
    }

    public void testArrayServiceWSDL() throws Exception
    {
        TransportManager tm = (TransportManager) lookup( TransportManager.ROLE );
        tm.register( new TestHttpTransport() );
        
        Document doc = getWSDLDocument("Array");
        
        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "wsdlsoap", WSDL.WSDL11_SOAP_NS );
        addNamespace( "xsd", SOAPConstants.XSD );

        assertValid( "/wsdl:definitions/wsdl:types", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema[@targetNamespace='urn:Array']", doc );
        assertValid( "//xsd:schema[@targetNamespace='urn:Array']/xsd:element[@name='SubmitBeanArray']", doc );
        assertValid( "//xsd:element[@name='SubmitStringArray']/xsd:complexType/xsd:sequence/xsd:element[@name='in0'][@type='tns:ArrayOfString']", doc );
        assertValid( "//xsd:element[@name='SubmitBeanArray']/xsd:complexType/xsd:sequence/xsd:element[@name='in0'][@type='tns:ArrayOfSimpleBean']", doc );
    }
}
