package org.codehaus.xfire.java.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.AbstractJavaService;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class DocumentWSDLTest
    extends PlexusXFireTest
{
    public void testWSDL() throws Exception
    {
        AbstractJavaService echo = (AbstractJavaService) lookup( Service.ROLE, "Echo" );
        
        DocumentWSDL wsdl = (DocumentWSDL) echo.getWSDL();
        
        Definition def = wsdl.getDefinition();
        
        wsdl.write( System.out );
        
        Message request = def.getMessage( new QName("urn:Echo", "echoRequest") );
        
        assertNotNull( request );
        assertNotNull( request.getPart( "in0" ) );
        assertEquals( "in0", request.getPart( "in0" ).getElementName().getLocalPart() );
        
        Message response = def.getMessage( new QName("urn:Echo", "echoResponse") );
        
        assertNotNull( response );
        assertNotNull( response.getPart( "out" ) );
        assertEquals( "out", response.getPart( "out" ).getElementName().getLocalPart() );
        
        Document doc = wsdl.getDocument();

        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "xsd", SOAPConstants.XSD );

        assertValid( "/wsdl:definitions/wsdl:types", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"in0\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"out\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"in0\"][@type=\"xsd:string\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"out\"][@type=\"xsd:string\"]", doc );
    }
}
