package org.codehaus.xfire.java.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.AbstractJavaService;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class RPCLiteralWSDLTest
    extends PlexusXFireTest
{
    public void testWSDL() throws Exception
    {
        AbstractJavaService echo = (AbstractJavaService) lookup( Service.ROLE, "Echo" );
        
        RPCLiteralWSDL wsdl = (RPCLiteralWSDL) echo.getWSDL();
        
        Definition def = wsdl.getDefinition();
        
        wsdl.write( System.out );
        
        Message request = def.getMessage( new QName("urn:Echo", "echoRequest") );
        
        assertNotNull( request );
        assertNotNull( request.getPart( "in0" ) );
        assertEquals( "string", request.getPart( "in0" ).getTypeName().getLocalPart() );
        assertNull( request.getPart("in0").getElementName() );
        
        Message response = def.getMessage( new QName("urn:Echo", "echoResponse") );
        
        assertNotNull( response );
        assertNotNull( response.getPart( "out" ) );
        assertEquals( "string", response.getPart( "out" ).getTypeName().getLocalPart() );
        assertNull( response.getPart("out").getElementName() );
        
        Document doc = wsdl.getDocument();

        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "xsd", SOAPConstants.XSD );
        // TODO: add xpath tests.
    }
}
