package org.codehaus.xfire.java.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.xml.namespace.QName;
import org.codehaus.xfire.SOAPConstants;
import org.codehaus.xfire.java.AbstractJavaService;
import org.codehaus.xfire.plexus.PlexusXFireTest;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.wsdl.WSDL;
import org.dom4j.Document;


/**
 * @author <a href="mailto:dan@envoisolutions.com">Dan Diephouse</a>
 * @since Feb 21, 2004
 */
public class WrappedWSDLTest
    extends PlexusXFireTest
{
    public void testWSDL() throws Exception
    {
        AbstractJavaService echo = (AbstractJavaService) lookup( Service.ROLE, "Echo" );
        
        WrappedWSDL wsdl = (WrappedWSDL) echo.getWSDL();
        
        Definition def = wsdl.getDefinition();
        
        wsdl.write( System.out );
        
        Message request = def.getMessage( new QName("urn:Echo", "echoRequest") );
        
        assertNotNull( request );
        assertNotNull( request.getPart( "parameters" ) );
        assertNotNull( request.getPart( "parameters" ).getElementName() );
        
        Message response = def.getMessage( new QName("urn:Echo", "echoResponse") );
        
        assertNotNull( response );
        assertNotNull( response.getPart( "parameters" ) );
        assertNotNull( response.getPart( "parameters" ).getElementName() );
        
        Document doc = wsdl.getDocument();

        addNamespace( "wsdl", WSDL.WSDL11_NS );
        addNamespace( "xsd", SOAPConstants.XSD );

        assertValid( "/wsdl:definitions/wsdl:types", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"echo\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"echoResponse\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"echo\"]/xsd:complexType/xsd:sequence/xsd:element[@name=\"in0\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"echo\"]/xsd:complexType/xsd:sequence/xsd:element[@type=\"xsd:string\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"echoResponse\"]/xsd:complexType/xsd:sequence/xsd:element[@name=\"out\"]", doc );
        assertValid( "/wsdl:definitions/wsdl:types/xsd:schema/xsd:element[@name=\"echoResponse\"]/xsd:complexType/xsd:sequence/xsd:element[@type=\"xsd:string\"]", doc );
    }
}
