/*
 * Decompiled with CFR 0.152.
 */
package ca.jeb.common.infra;

import ca.jeb.common.infra.JException;
import ca.jeb.common.infra.JStringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class JReflectionUtils {
    private static final Map<String, Map<String, Method>> METHOD_FIELD_MAP_CACHE = Collections.synchronizedMap(new WeakHashMap());

    private JReflectionUtils() {
    }

    public static Object runGetter(Object object, Field field) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        String fieldName = field.getName();
        Map<String, Method> fieldMethodMap = METHOD_FIELD_MAP_CACHE.get(object.getClass().getCanonicalName());
        if (fieldMethodMap != null) {
            Method fieldMethod = fieldMethodMap.get(fieldName);
            if (fieldMethod != null) {
                return fieldMethod.invoke(object, new Object[0]);
            }
        } else {
            fieldMethodMap = new HashMap<String, Method>();
        }
        try {
            Method method = clazz.getMethod("get" + JStringUtils.upperCaseFirst(fieldName), null);
            fieldMethodMap.put(fieldName, method);
            METHOD_FIELD_MAP_CACHE.put(object.getClass().getCanonicalName(), fieldMethodMap);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            for (Method method : clazz.getMethods()) {
                String methodName = method.getName();
                if ((!methodName.startsWith("get") || methodName.length() != fieldName.length() + "get".length()) && (!methodName.startsWith("is") || methodName.length() != fieldName.length() + "is".length()) || !methodName.toLowerCase().endsWith(fieldName.toLowerCase())) continue;
                fieldMethodMap.put(fieldName, method);
                METHOD_FIELD_MAP_CACHE.put(object.getClass().getCanonicalName(), fieldMethodMap);
                return method.invoke(object, new Object[0]);
            }
            return null;
        }
    }

    public static Object runSetter(Object object, String method, Object arg, Class<? extends Object> argClazz) throws JException {
        try {
            if (argClazz == null) {
                argClazz = arg.getClass();
            }
            Method m = object.getClass().getMethod(method, argClazz);
            return m.invoke(object, arg);
        }
        catch (Exception e) {
            throw new JException(e);
        }
    }

    public static Object runMethod(Object object, String method, Object ... args) throws JException {
        try {
            Method m = object.getClass().getMethod(method, new Class[0]);
            return m.invoke(object, args);
        }
        catch (Exception e) {
            throw new JException(e);
        }
    }

    public static List<Field> getAllFields(List<Field> fields, Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(field);
        }
        if (clazz.getSuperclass() != null) {
            fields = JReflectionUtils.getAllFields(fields, clazz.getSuperclass());
        }
        return fields;
    }

    public static List<Method> getAllMethods(List<Method> methods, Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            methods.add(method);
        }
        if (clazz.getSuperclass() != null) {
            methods = JReflectionUtils.getAllMethods(methods, clazz.getSuperclass());
        }
        return methods;
    }

    public static Method getMethodByName(Class<?> clazz, String name) {
        List<Method> methods = JReflectionUtils.getAllMethods(new ArrayList<Method>(), clazz);
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }
}

