/*
 * Decompiled with CFR 0.152.
 */
package ca.jeb.common.spring;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;

public final class SpringMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringMain.class);
    private GenericApplicationContext context;
    private String[] configLocations;

    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("Please provide a config location");
        }
        final SpringMain sm = new SpringMain();
        sm.setConfigLocations(args);
        if (System.getSecurityManager() == null) {
            sm.runInternal();
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    sm.runInternal();
                    return null;
                }
            });
        }
    }

    private void runInternal() {
        if (this.context == null) {
            this.context = new GenericApplicationContext();
        }
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context);
        AnnotatedBeanDefinitionReader classReader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)this.context);
        for (String configLocation : this.configLocations) {
            if (this.registerClass(classReader, configLocation)) continue;
            xmlReader.loadBeanDefinitions(configLocation);
        }
        boolean started = false;
        try {
            this.context.registerShutdownHook();
            this.context.refresh();
            LOGGER.info("SpringMain has completed startup!");
            started = true;
        }
        catch (Throwable t) {
            LOGGER.error("SpringMain startup failed", t);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("SpringMain failed startup: " + t, t);
        }
        finally {
            if (!started) {
                try {
                    this.context.close();
                }
                catch (Throwable e) {
                    LOGGER.error("Ignoring exception during application close due to exception at startup: " + e, e);
                }
            }
        }
    }

    private boolean registerClass(AnnotatedBeanDefinitionReader classReader, String className) {
        if (className.indexOf(47) != -1 || className.indexOf(58) != -1) {
            return false;
        }
        try {
            Class<?> configClass = this.getClass().getClassLoader().loadClass(className);
            classReader.register(new Class[]{configClass});
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String[] getConfigLocations() {
        return this.configLocations;
    }

    public void setConfigLocations(String ... configLocations) {
        this.configLocations = configLocations;
    }
}

