/*
 * Decompiled with CFR 0.152.
 */
package org.changelog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.changelog.Commit;
import org.changelog.CommitNote;
import org.changelog.CommitParserKt;
import org.changelog.CommitReference;
import org.changelog.ParserOptions;
import org.changelog.ParserRegexes;
import org.changelog.RegexParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0011J\u000e\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010#\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020\u0014J \u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160'2\u0006\u0010\u001c\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160'2\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000bJ\b\u0010*\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/changelog/CommitParser;", "", "options", "Lorg/changelog/ParserOptions;", "(Lorg/changelog/ParserOptions;)V", "commit", "Lorg/changelog/Commit;", "lineIndex", "", "lines", "", "", "getOptions", "()Lorg/changelog/ParserOptions;", "regexes", "Lorg/changelog/ParserRegexes;", "cleanupCommit", "", "currentLine", "isLineAvailable", "", "matchToReference", "Lorg/changelog/CommitReference;", "matches", "Lkotlin/text/MatchResult;", "action", "nextLine", "parse", "input", "parseBodyAndFooter", "isBody", "parseBreakingHeader", "parseHeader", "isMergeCommit", "parseMentions", "parseMerge", "parseMeta", "parseNotes", "parseReference", "", "parseReferences", "parseRevert", "skipEmptyLines", "git-commit-message"})
@SourceDebugExtension(value={"SMAP\nCommitParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitParser.kt\norg/changelog/CommitParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,420:1\n1#2:421\n1864#3,3:422\n1864#3,3:425\n1559#3:430\n1590#3,4:431\n1855#3,2:435\n766#3:437\n857#3,2:438\n1313#4,2:428\n*S KotlinDebug\n*F\n+ 1 CommitParser.kt\norg/changelog/CommitParser\n*L\n171#1:422,3\n197#1:425,3\n348#1:430\n348#1:431,4\n365#1:435,2\n382#1:437\n382#1:438,2\n335#1:428,2\n*E\n"})
public final class CommitParser {
    @NotNull
    private final ParserOptions options;
    @NotNull
    private final ParserRegexes regexes;
    @NotNull
    private final List<String> lines;
    private int lineIndex;
    @NotNull
    private Commit commit;

    public CommitParser(@NotNull ParserOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.regexes = RegexParser.INSTANCE.getParserRegexes(this.options);
        this.lines = new ArrayList();
        this.commit = CommitParserKt.createCommitObject();
    }

    public /* synthetic */ CommitParser(ParserOptions parserOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parserOptions = ParserOptions.Companion.defaultOptions();
        }
        this(parserOptions);
    }

    @NotNull
    public final ParserOptions getOptions() {
        return this.options;
    }

    private final String currentLine() {
        return (String)CollectionsKt.getOrNull(this.lines, (int)this.lineIndex);
    }

    private final String nextLine() {
        int n = this.lineIndex;
        this.lineIndex = n + 1;
        return (String)CollectionsKt.getOrNull(this.lines, (int)n);
    }

    private final boolean isLineAvailable() {
        return this.lineIndex < this.lines.size();
    }

    private final List<CommitReference> parseReference(String input, String action) {
        ParserRegexes regexes = this.regexes;
        Sequence matches = Regex.findAll$default((Regex)regexes.getReferenceParts(), (CharSequence)input, (int)0, (int)2, null);
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)matches, (Function1)((Function1)new Function1<MatchResult, CommitReference>(this, action){
            final /* synthetic */ CommitParser this$0;
            final /* synthetic */ String $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(1);
            }

            @NotNull
            public final CommitReference invoke(@NotNull MatchResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CommitParser.access$matchToReference(this.this$0, it, this.$action);
            }
        })));
    }

    private final CommitReference matchToReference(MatchResult matches, String action) {
        int slashIndex;
        Object object;
        Object prefix;
        MatchGroup matchGroup = matches.getGroups().get(0);
        String raw = matchGroup != null ? matchGroup.getValue() : null;
        MatchGroup matchGroup2 = matches.getGroups().get(1);
        String repository = matchGroup2 != null ? matchGroup2.getValue() : null;
        Object object2 = matches.getGroups().get(2);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            object2 = prefix = "";
        }
        if ((object = matches.getGroups().get(3)) == null || (object = object.getValue()) == null) {
            object = "";
        }
        Object issue = object;
        String owner = null;
        CharSequence charSequence = repository;
        if (!(charSequence == null || charSequence.length() == 0) && (slashIndex = StringsKt.indexOf$default((CharSequence)repository, (char)'/', (int)0, (boolean)false, (int)6, null)) != -1) {
            String string = repository.substring(0, slashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            owner = string;
            String string2 = repository.substring(slashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            repository = string2;
        }
        String string = raw;
        Intrinsics.checkNotNull((Object)string);
        charSequence = string;
        String string3 = owner;
        String string4 = repository;
        return new CommitReference((String)charSequence, action, string3, string4, (String)issue, (String)prefix);
    }

    @NotNull
    public final List<CommitReference> parseReferences(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Regex regex = Regex.find$default((Regex)this.regexes.getReferences(), (CharSequence)input, (int)0, (int)2, null) != null ? this.regexes.getReferences() : new Regex("()(.+)", SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
        return SequencesKt.toList((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null), (Function1)((Function1)new Function1<MatchResult, List<? extends CommitReference>>(this){
            final /* synthetic */ CommitParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<CommitReference> invoke(@NotNull MatchResult matches) {
                String firstValue;
                Intrinsics.checkNotNullParameter((Object)matches, (String)"matches");
                String string = firstValue = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)1);
                String action = (string != null ? ((CharSequence)string).length() > 0 : false) ? firstValue : null;
                String string2 = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)2);
                if (string2 == null) {
                    string2 = "";
                }
                String sentence = string2;
                return CommitParser.access$parseReference(this.this$0, sentence, action);
            }
        }))));
    }

    private final void skipEmptyLines() {
        String line = this.currentLine();
        while (line != null && StringsKt.isBlank((CharSequence)line)) {
            this.nextLine();
            line = this.currentLine();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean parseMerge() {
        MatchResult matches;
        MatchResult matchResult;
        String merge;
        Commit commit = this.commit;
        ParserOptions options = this.options;
        List list = options.getMergeCorrespondence();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List correspondence = list;
        String string = merge = this.currentLine();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Regex regex = options.getMergePattern();
            matchResult = regex != null ? Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null) : null;
        } else {
            matchResult = matches = null;
        }
        if (matches != null) {
            this.nextLine();
            commit.setMerge((String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)0));
            Iterable $this$forEachIndexed$iv = correspondence;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void key;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv;
                int index = n;
                boolean bl = false;
                commit.getMeta().put((String)key, (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)(index + 1)));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void parseHeader(boolean isMergeCommit) {
        MatchResult matches;
        MatchResult matchResult;
        String header;
        if (isMergeCommit) {
            this.skipEmptyLines();
        }
        Commit commit = this.commit;
        ParserOptions options = this.options;
        List list = options.getHeaderCorrespondence();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List correspondence = list;
        String string = header = this.nextLine();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Regex regex = options.getHeaderPattern();
            matchResult = regex != null ? Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null) : null;
        } else {
            matchResult = matches = null;
        }
        if (header != null) {
            commit.setHeader(header);
        }
        if (matches != null) {
            Iterable $this$forEachIndexed$iv = correspondence;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void key;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv;
                int index = n;
                boolean bl = false;
                String orNull = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)(index + 1));
                String string3 = orNull;
                commit.getMeta().put((String)key, (string3 != null ? ((CharSequence)string3).length() > 0 : false) ? orNull : null);
            }
        }
    }

    public final boolean parseMeta() {
        ParserOptions options = this.options;
        Commit commit = this.commit;
        if (options.getFieldPattern() == null || !this.isLineAvailable()) {
            return false;
        }
        MatchResult matches = null;
        String field = null;
        boolean parsed = false;
        while (this.isLineAvailable()) {
            MatchResult matchResult;
            Regex regex = options.getFieldPattern();
            if (regex != null) {
                String string = this.currentLine();
                Intrinsics.checkNotNull((Object)string);
                matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
            } else {
                matchResult = matches = null;
            }
            if (matches != null) {
                field = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)1);
                this.nextLine();
                continue;
            }
            if (field == null) break;
            parsed = true;
            Map<String, String> map = commit.getMeta();
            String string = this.currentLine();
            Intrinsics.checkNotNull((Object)string);
            map.put(field, CommitParserKt.appendLine(commit.getMeta().get(field), string));
            this.nextLine();
        }
        return parsed;
    }

    public final boolean parseNotes() {
        ParserRegexes regexes = this.regexes;
        Commit commit = this.commit;
        if (!this.isLineAvailable()) {
            return false;
        }
        Regex regex = regexes.getNotes();
        String string = this.currentLine();
        Intrinsics.checkNotNull((Object)string);
        MatchResult matches = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        List<CommitReference> references = CollectionsKt.emptyList();
        if (matches != null) {
            String string2;
            String string3 = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)1);
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)2)) == null) {
                string2 = "";
            }
            CommitNote note = new CommitNote(string3, string2);
            commit.getNotes().add(note);
            commit.setFooter(CommitParserKt.appendLine(commit.getFooter(), this.currentLine()));
            this.nextLine();
            while (this.isLineAvailable()) {
                if (this.parseMeta()) {
                    return true;
                }
                if (this.parseNotes()) {
                    return true;
                }
                String string4 = this.currentLine();
                Intrinsics.checkNotNull((Object)string4);
                references = this.parseReferences(string4);
                if (!((Collection)references).isEmpty()) {
                    commit.getReferences().addAll((Collection<CommitReference>)references);
                } else {
                    note.setText(CommitParserKt.appendLine(note.getText(), this.currentLine()));
                }
                commit.setFooter(CommitParserKt.appendLine(commit.getFooter(), this.currentLine()));
                this.nextLine();
                if (!(!((Collection)references).isEmpty())) continue;
            }
            return true;
        }
        return false;
    }

    public final boolean parseBodyAndFooter(boolean isBody) {
        boolean isStillBody;
        Commit commit = this.commit;
        if (!this.isLineAvailable()) {
            return isBody;
        }
        String string = this.currentLine();
        Intrinsics.checkNotNull((Object)string);
        List<CommitReference> references = this.parseReferences(string);
        boolean bl = isStillBody = references.isEmpty() && isBody;
        if (isStillBody) {
            commit.setBody(CommitParserKt.appendLine(commit.getBody(), this.currentLine()));
        } else {
            commit.getReferences().addAll((Collection<CommitReference>)references);
            commit.setFooter(CommitParserKt.appendLine(commit.getFooter(), this.currentLine()));
        }
        this.nextLine();
        return isStillBody;
    }

    public final void parseBreakingHeader() {
        Commit commit = this.commit;
        ParserOptions options = this.options;
        if (options.getBreakingHeaderPattern() == null || !((Collection)commit.getNotes()).isEmpty() || commit.getHeader() == null) {
            return;
        }
        Regex regex = options.getBreakingHeaderPattern();
        String string = commit.getHeader();
        Intrinsics.checkNotNull((Object)string);
        MatchResult matches = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (matches != null) {
            List<CommitNote> list = commit.getNotes();
            String string2 = (String)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)3);
            if (string2 == null) {
                string2 = "";
            }
            list.add(new CommitNote("BREAKING CHANGE", string2));
        }
    }

    public final void parseMentions(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Commit commit = this.commit;
        ParserRegexes regexes = this.regexes;
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)regexes.getMentions(), (CharSequence)input, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult matchResult = (MatchResult)element$iv;
            boolean bl = false;
            String match = (String)matchResult.getGroupValues().get(1);
            commit.getMentions().add(match);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void parseRevert(@NotNull String input) {
        MatchResult matches;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Commit commit = this.commit;
        ParserOptions options = this.options;
        List list = options.getRevertCorrespondence();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List correspondence = list;
        Regex regex = options.getRevertPattern();
        MatchResult matchResult = matches = regex != null ? Regex.find$default((Regex)regex, (CharSequence)input, (int)0, (int)2, null) : null;
        if (matches != null) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = correspondence;
            Commit commit2 = commit;
            boolean $i$f$mapIndexed = false;
            void var8_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void key;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)key, (Object)CollectionsKt.getOrNull((List)matches.getGroupValues(), (int)(index + true))));
            }
            commit2.setRevert(MapsKt.toMap((Iterable)((List)destination$iv$iv)));
        }
    }

    public final void cleanupCommit() {
        Commit commit = this.commit;
        if (commit.getBody() != null) {
            String string = commit.getBody();
            Intrinsics.checkNotNull((Object)string);
            commit.setBody(CommitParserKt.trimNewLines(string));
        }
        if (commit.getFooter() != null) {
            String string = commit.getFooter();
            Intrinsics.checkNotNull((Object)string);
            commit.setFooter(CommitParserKt.trimNewLines(string));
        }
        Iterable $this$forEach$iv = commit.getNotes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommitNote note = (CommitNote)element$iv;
            boolean bl = false;
            note.setText(CommitParserKt.trimNewLines(note.getText()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Commit parse(@NotNull String input) {
        Commit commit;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)input)).toString()).length() == 0) {
            throw new IllegalArgumentException("Expected a raw commit");
        }
        Function1<String, Boolean> commentFilter = CommitParserKt.getCommentFilter(this.options.getCommentChar());
        CharSequence charSequence = CommitParserKt.trimNewLines(input);
        Regex regex = new Regex("\r?\n");
        int n = 0;
        List rawLines = regex.split(charSequence, n);
        Iterable $this$filter$iv = CommitParserKt.truncateToScissor(rawLines);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String line = (String)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)commentFilter.invoke((Object)line) != false && CommitParserKt.gpgFilter(line))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        this.lines.clear();
        this.lines.addAll(lines);
        this.lineIndex = 0;
        this.commit = commit = CommitParserKt.createCommitObject();
        boolean isMergeCommit = this.parseMerge();
        this.parseHeader(isMergeCommit);
        if (commit.getHeader() != null) {
            List<CommitReference> list = commit.getReferences();
            String string = commit.getHeader();
            Intrinsics.checkNotNull((Object)string);
            list.addAll((Collection<CommitReference>)this.parseReferences(string));
        }
        boolean isBody = true;
        while (this.isLineAvailable()) {
            this.parseMeta();
            if (this.parseNotes()) {
                isBody = false;
            }
            if (this.parseBodyAndFooter(isBody)) continue;
            isBody = false;
        }
        this.parseBreakingHeader();
        this.parseMentions(input);
        this.parseRevert(input);
        this.cleanupCommit();
        return commit;
    }

    public CommitParser() {
        this(null, 1, null);
    }

    public static final /* synthetic */ CommitReference access$matchToReference(CommitParser $this, MatchResult matches, String action) {
        return $this.matchToReference(matches, action);
    }

    public static final /* synthetic */ List access$parseReference(CommitParser $this, String input, String action) {
        return $this.parseReference(input, action);
    }
}

