/*
 * Decompiled with CFR 0.152.
 */
package org.changelog;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.changelog.ParserOptions;
import org.changelog.ParserRegexes;
import org.changelog.RegexParserKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0018\u00010\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ'\u0010\u000e\u001a\u00020\u00042\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00042\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/changelog/RegexParser;", "", "()V", "getNotesRegex", "Lkotlin/text/Regex;", "noteKeywords", "", "", "notesPattern", "Lkotlin/Function1;", "getParserRegexes", "Lorg/changelog/ParserRegexes;", "options", "Lorg/changelog/ParserOptions;", "getReferencePartsRegex", "issuePrefixes", "issuePrefixesCaseSensitive", "", "(Ljava/util/List;Ljava/lang/Boolean;)Lkotlin/text/Regex;", "getReferencesRegex", "referenceActions", "git-commit-message"})
public final class RegexParser {
    @NotNull
    public static final RegexParser INSTANCE = new RegexParser();

    private RegexParser() {
    }

    @NotNull
    public final ParserRegexes getParserRegexes(@NotNull ParserOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Regex notes = this.getNotesRegex(options.getNoteKeywords(), options.getNotesPattern());
        Regex referenceParts = this.getReferencePartsRegex(options.getIssuePrefixes(), options.getIssuePrefixesCaseSensitive());
        Regex references = this.getReferencesRegex(options.getReferenceActions());
        return new ParserRegexes(notes, referenceParts, references, new Regex("@([\\w-]+)"));
    }

    private final Regex getNotesRegex(List<String> noteKeywords, Function1<? super String, Regex> notesPattern) {
        Regex nomatchRegex = new Regex("(?!.*)");
        if (noteKeywords == null) {
            return nomatchRegex;
        }
        String noteKeywordsSelection = RegexParserKt.join(noteKeywords, "|");
        if (notesPattern == null) {
            return new Regex("^[\\s|*]*(" + noteKeywordsSelection + ")[:\\s]+(.*)", SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
        }
        Object object = notesPattern.invoke((Object)noteKeywordsSelection);
        Intrinsics.checkNotNull((Object)object);
        return (Regex)object;
    }

    private final Regex getReferencePartsRegex(List<String> issuePrefixes, Boolean issuePrefixesCaseSensitive) {
        if (issuePrefixes == null) {
            return RegexParserKt.getNomatchRegex();
        }
        Set flags = Intrinsics.areEqual((Object)issuePrefixesCaseSensitive, (Object)true) ? SetsKt.setOf((Object)RegexOption.MULTILINE) : SetsKt.setOf((Object)RegexOption.IGNORE_CASE);
        return new Regex("(?:.*?)??\\s*([\\w-\\.\\/]*?)??(" + RegexParserKt.join(issuePrefixes, "|") + ")([\\w-]*\\d+)", flags);
    }

    private final Regex getReferencesRegex(List<String> referenceActions) {
        if (referenceActions == null) {
            return new Regex("()(.+)", SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
        }
        String joinedKeywords = RegexParserKt.join(referenceActions, "|");
        return new Regex("(" + joinedKeywords + ")(?:\\s+(.*?))(?=(?:" + joinedKeywords + ")|$)", SetsKt.setOf((Object)RegexOption.IGNORE_CASE));
    }
}

