/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.cf.code;

import cc.unitmesh.cf.code.GitOutput;
import cc.unitmesh.cf.code.command.Command;
import cc.unitmesh.cf.code.command.ExecOptions;
import cc.unitmesh.cf.code.command.StringListExecListeners;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003J*\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcc/unitmesh/cf/code/GitCommand;", "", "workingDirectory", "", "(Ljava/lang/String;)V", "exec", "Lcc/unitmesh/cf/code/command/Command;", "gitEnv", "", "gitPath", "checkout", "Lcc/unitmesh/cf/code/GitOutput;", "ref", "startPoint", "execGit", "args", "", "allowAllExitCodes", "", "silent", "latestCommitHash", "num", "", "log", "format", "Companion", "git-differ"})
public final class GitCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String workingDirectory;
    @NotNull
    private final Map<String, String> gitEnv;
    @NotNull
    private String gitPath;
    @NotNull
    private final Command exec;
    private static final Logger logger = LoggerFactory.getLogger(GitCommand.class);

    public GitCommand(@NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        this.workingDirectory = workingDirectory;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"GIT_TERMINAL_PROMPT", (Object)"0"), TuplesKt.to((Object)"GCM_INTERACTIVE", (Object)"Never")};
        this.gitEnv = MapsKt.mutableMapOf((Pair[])pairArray);
        this.gitPath = "git";
        this.exec = new Command();
    }

    public /* synthetic */ GitCommand(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        this(string);
    }

    @NotNull
    public final GitOutput checkout(@NotNull String ref, @Nullable String startPoint) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Object[] objectArray = new String[]{"checkout", "--progress", "--force"};
        List args = CollectionsKt.mutableListOf((Object[])objectArray);
        if (startPoint != null) {
            objectArray = new String[]{"-B", ref, startPoint};
            args.addAll(CollectionsKt.listOf((Object[])objectArray));
        } else {
            args.add(ref);
        }
        return GitCommand.execGit$default(this, args, false, false, 6, null);
    }

    public static /* synthetic */ GitOutput checkout$default(GitCommand gitCommand, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gitCommand.checkout(string, string2);
    }

    @NotNull
    public final GitOutput log(@Nullable String format) {
        List list;
        if (format != null) {
            var3_2 = new String[]{"log", "-1", format};
            list = CollectionsKt.listOf((Object[])var3_2);
        } else {
            var3_2 = new String[]{"log", "-1"};
            list = CollectionsKt.listOf((Object[])var3_2);
        }
        List args = list;
        boolean silent = format != null;
        return this.execGit(args, false, silent);
    }

    public static /* synthetic */ GitOutput log$default(GitCommand gitCommand, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return gitCommand.log(string);
    }

    @NotNull
    public final GitOutput latestCommitHash(int num) {
        String format = "--pretty=format:%h";
        Object[] objectArray = new String[]{"log", "-" + num, format};
        List args = CollectionsKt.listOf((Object[])objectArray);
        return this.execGit(args, false, true);
    }

    public static /* synthetic */ GitOutput latestCommitHash$default(GitCommand gitCommand, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return gitCommand.latestCommitHash(n);
    }

    private final GitOutput execGit(List<String> args, boolean allowAllExitCodes, boolean silent) {
        String value;
        String key;
        GitOutput result = new GitOutput(null, 0, 3, null);
        Map env = new LinkedHashMap();
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            Intrinsics.checkNotNull((Object)key);
            Intrinsics.checkNotNull((Object)value);
            env.put(key, value);
        }
        for (Map.Entry<String, String> entry : this.gitEnv.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            env.put(key, value);
        }
        List stdout = new ArrayList();
        List stderr = new ArrayList();
        ExecOptions options = new ExecOptions(this.workingDirectory, env, silent, allowAllExitCodes, new StringListExecListeners(stdout, stderr));
        result.setExitCode(this.exec.exec(this.gitPath, args, options));
        result.setStdout(CollectionsKt.joinToString$default((Iterable)stdout, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        if (((CharSequence)result.getStdout()).length() > 0) {
            logger.info("execGit: git " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            logger.info(result.getStdout());
        }
        if (result.getExitCode() != 0) {
            logger.error(CollectionsKt.joinToString$default((Iterable)stderr, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
        return result;
    }

    static /* synthetic */ GitOutput execGit$default(GitCommand gitCommand, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return gitCommand.execGit(list, bl, bl2);
    }

    public GitCommand() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcc/unitmesh/cf/code/GitCommand$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "git-differ"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

