/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.database.MetaStorage;
import chat.dim.dbi.MetaDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.ID;
import chat.dim.protocol.Meta;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.MetaTable;
import java.util.Date;

public class MetaDatabase
implements MetaDBI {
    private final MetaStorage metaStorage;
    private final MetaTable metaTable;
    private final CachePool<ID, Meta> metaCache;

    public MetaDatabase(String rootDir, String publicDir, String privateDir, DatabaseConnector sqliteConnector) {
        this.metaStorage = new MetaStorage(rootDir, publicDir, privateDir);
        this.metaTable = new MetaTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.metaCache = man.getPool("meta");
    }

    public void showInfo() {
        this.metaStorage.showInfo();
    }

    public boolean saveMeta(Meta meta, ID entity) {
        Meta old = this.getMeta(entity);
        if (old != null) {
            return true;
        }
        this.metaCache.update((Object)entity, (Object)meta, 36000000L, 0L);
        this.metaTable.saveMeta(meta, entity);
        return this.metaStorage.saveMeta(meta, entity);
    }

    public Meta getMeta(ID entity) {
        long now = new Date().getTime();
        Meta meta = null;
        CacheHolder holder = null;
        CachePair pair = this.metaCache.fetch((Object)entity, now);
        if (pair != null) {
            meta = (Meta)pair.value;
            holder = pair.holder;
        }
        if (meta == null) {
            if (holder == null) {
                this.metaCache.update((Object)entity, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            meta = this.metaTable.getMeta(entity);
            if (meta == null) {
                meta = this.metaStorage.getMeta(entity);
            }
            this.metaCache.update((Object)entity, (Object)meta, 36000000L, now);
        }
        return meta;
    }
}

