/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite;

import chat.dim.sql.SQLBuilder;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.DatabaseHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class DataTableHandler<T>
extends DatabaseHandler<T> {
    public DataTableHandler(DatabaseConnector sqliteConnector) {
        super(sqliteConnector);
    }

    protected abstract DataRowExtractor<T> getDataRowExtractor();

    public boolean createTable(String table, String[] fields) {
        String sql = SQLBuilder.buildCreateTable(table, fields);
        try {
            this.executeUpdate(sql);
            return true;
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int insert(String table, String[] columns, Object[] values) {
        String sql = SQLBuilder.buildInsert(table, columns, values);
        try {
            return this.executeUpdate(sql);
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public List<T> select(String table, String[] columns, SQLConditions conditions) {
        return this.select(table, columns, conditions, null, null, null, -1, 0);
    }

    public List<T> select(String table, String[] columns, SQLConditions conditions, String groupBy, String having, String orderBy, int limit, int offset) {
        String sql = SQLBuilder.buildSelect(false, columns, table, conditions, groupBy, having, orderBy, limit, offset);
        try {
            return this.executeQuery(sql, this.getDataRowExtractor());
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int update(String table, Map<String, Object> values, SQLConditions conditions) {
        String sql = SQLBuilder.buildUpdate(table, values, conditions);
        try {
            return this.executeUpdate(sql);
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int delete(String table, SQLConditions conditions) {
        String sql = SQLBuilder.buildDelete(table, conditions);
        try {
            return this.executeUpdate(sql);
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

