/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite;

import chat.dim.filesys.PathUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DatabaseConnector {
    private final String dbFilePath;
    private Connection connection;

    public DatabaseConnector(String sqliteFilePath) {
        this.dbFilePath = sqliteFilePath;
        this.connection = null;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public void destroy() throws SQLException {
        Connection conn = this.connection;
        if (conn != null) {
            this.connection = null;
            conn.close();
        }
    }

    public Connection getConnection() throws SQLException, IOException {
        Connection conn = this.connection;
        if (conn == null) {
            String parent = PathUtils.parent((String)this.dbFilePath);
            File dir = new File(parent);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("failed to create dir for db file: " + this.dbFilePath);
            }
            this.connection = conn = DriverManager.getConnection("jdbc:sqlite:" + this.dbFilePath);
        }
        return conn;
    }
}

