/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.UserDBI;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import java.util.HashMap;
import java.util.List;

public class UserTable
extends DataTableHandler<ID>
implements UserDBI {
    private DataRowExtractor<ID> extractor = null;
    private static final String[] SELECT_COLUMNS = new String[]{"user"};
    private static final String[] INSERT_COLUMNS = new String[]{"user", "chosen"};
    private static final String T_USER = "t_local_user";

    public UserTable(DatabaseConnector connector) {
        super(connector);
    }

    @Override
    protected DataRowExtractor<ID> getDataRowExtractor() {
        return this.extractor;
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "user VARCHAR(64)", "chosen BIT"};
            if (!this.createTable(T_USER, fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String user = resultSet.getString("user");
                return ID.parse((Object)user);
            };
        }
        return true;
    }

    public List<ID> getLocalUsers() {
        if (!this.prepare()) {
            return null;
        }
        return this.select(T_USER, SELECT_COLUMNS, null, null, null, "chosen DESC", -1, 0);
    }

    public boolean saveLocalUsers(List<ID> users) {
        HashMap<String, Object> values;
        SQLConditions conditions;
        List<ID> localUsers = this.getLocalUsers();
        if (localUsers == null) {
            return false;
        }
        for (ID identifier : localUsers) {
            if (users.contains(identifier)) continue;
            conditions = new SQLConditions();
            conditions.addCondition(null, "user", "=", identifier.toString());
            if (this.delete(T_USER, conditions) >= 0) continue;
            return false;
        }
        for (ID identifier : users) {
            Object[] values2;
            if (localUsers.contains(identifier) || this.insert(T_USER, INSERT_COLUMNS, values2 = new Object[]{identifier.toString(), 0}) >= 0) continue;
            return false;
        }
        if (users.size() == 0) {
            return true;
        }
        ID first = users.get(0);
        if (localUsers.size() == 0 || !localUsers.get(0).equals(first)) {
            values = new HashMap<String, Object>();
            values.put("chosen", 0);
            if (this.update(T_USER, values, null) < 0) {
                return false;
            }
        }
        values = new HashMap();
        values.put("chosen", 1);
        conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", first.toString());
        return this.update(T_USER, values, null) > 0;
    }

    public List<ID> getContacts(ID user) {
        throw new AssertionError((Object)"call ContactTable");
    }

    public boolean saveContacts(List<ID> contacts, ID user) {
        throw new AssertionError((Object)"call ContactTable");
    }
}

