/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.database.DocumentStorage;
import chat.dim.dbi.DocumentDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.Document;
import chat.dim.protocol.ID;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.DocumentTable;
import java.util.Date;

public class DocumentDatabase
implements DocumentDBI {
    private final DocumentStorage documentStorage;
    private final DocumentTable documentTable;
    private final CachePool<ID, Document> documentCache;

    public DocumentDatabase(String rootDir, String publicDir, String privateDir, DatabaseConnector sqliteConnector) {
        this.documentStorage = new DocumentStorage(rootDir, publicDir, privateDir);
        this.documentTable = new DocumentTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.documentCache = man.getPool("document");
    }

    public void showInfo() {
        this.documentStorage.showInfo();
    }

    public boolean saveDocument(Document doc) {
        String type;
        ID identifier = doc.getIdentifier();
        Document old = this.getDocument(identifier, type = doc.getType());
        if (old != null) {
            Date oldTime = old.getTime();
            Date newTime = doc.getTime();
            if (newTime != null && oldTime != null && newTime.getTime() < oldTime.getTime()) {
                return false;
            }
        }
        this.documentCache.update((Object)identifier, (Object)doc, 3600000L, 0L);
        this.documentTable.saveDocument(doc);
        return this.documentStorage.saveDocument(doc);
    }

    public Document getDocument(ID entity, String type) {
        long now = System.currentTimeMillis();
        Document doc = null;
        CacheHolder holder = null;
        CachePair pair = this.documentCache.fetch((Object)entity, now);
        if (pair != null) {
            doc = (Document)pair.value;
            holder = pair.holder;
        }
        if (doc == null) {
            if (holder == null) {
                this.documentCache.update((Object)entity, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            doc = this.documentTable.getDocument(entity, type);
            if (doc == null) {
                doc = this.documentStorage.getDocument(entity, type);
            }
            this.documentCache.update((Object)entity, (Object)doc, 36000000L, now);
        }
        return doc;
    }
}

