/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.dbi.UserDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.ID;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.ContactTable;
import chat.dim.sqlite.account.UserTable;
import java.util.ArrayList;
import java.util.List;

public class UserDatabase
implements UserDBI {
    private final UserTable userTable;
    private final ContactTable contactTable;
    private final CachePool<String, List<ID>> dimCache;
    private final CachePool<ID, List<ID>> contactCache;

    public UserDatabase(String rootDir, String publicDir, String privateDir, DatabaseConnector sqliteConnector) {
        this.userTable = new UserTable(sqliteConnector);
        this.contactTable = new ContactTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.dimCache = man.getPool("dim");
        this.contactCache = man.getPool("contacts");
    }

    public void showInfo() {
    }

    public List<ID> getLocalUsers() {
        long now = System.currentTimeMillis();
        List<ID> users = null;
        CacheHolder holder = null;
        CachePair pair = this.dimCache.fetch((Object)"local_users", now);
        if (pair != null) {
            users = (List<ID>)pair.value;
            holder = pair.holder;
        }
        if (users == null) {
            if (holder == null) {
                this.dimCache.update((Object)"local_users", null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return new ArrayList<ID>();
                }
                holder.renewal(128000L, now);
            }
            users = this.userTable.getLocalUsers();
            this.dimCache.update((Object)"local_users", users, 36000000L, now);
        }
        return users;
    }

    public boolean saveLocalUsers(List<ID> users) {
        this.dimCache.update((Object)"local_users", users, 36000000L, 0L);
        return this.userTable.saveLocalUsers(users);
    }

    public List<ID> getContacts(ID user) {
        long now = System.currentTimeMillis();
        List<ID> contacts = null;
        CacheHolder holder = null;
        CachePair pair = this.contactCache.fetch((Object)user, now);
        if (pair != null) {
            contacts = (List<ID>)pair.value;
            holder = pair.holder;
        }
        if (contacts == null) {
            if (holder == null) {
                this.contactCache.update((Object)user, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return new ArrayList<ID>();
                }
                holder.renewal(128000L, now);
            }
            contacts = this.contactTable.getContacts(user);
            this.contactCache.update((Object)user, contacts, 36000000L, now);
        }
        return contacts;
    }

    public boolean saveContacts(List<ID> contacts, ID user) {
        this.contactCache.update((Object)user, contacts, 36000000L, 0L);
        return this.contactTable.saveContacts(contacts, user);
    }
}

