/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.DocumentDBI;
import chat.dim.protocol.Document;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import java.util.HashMap;
import java.util.List;

public class DocumentTable
extends DataTableHandler<Document>
implements DocumentDBI {
    private DataRowExtractor<Document> extractor = null;
    private static final String[] SELECT_COLUMNS = new String[]{"did", "type", "data", "signature"};
    private static final String[] INSERT_COLUMNS = new String[]{"did", "type", "data", "signature"};
    private static final String T_DOCUMENT = "t_document";

    public DocumentTable(DatabaseConnector connector) {
        super(connector);
    }

    @Override
    protected DataRowExtractor<Document> getDataRowExtractor() {
        return this.extractor;
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "did VARCHAR(64)", "type VARCHAR(8)", "data TEXT", "signature VARCHAR(88)"};
            if (!this.createTable(T_DOCUMENT, fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String did = resultSet.getString("did");
                String type = resultSet.getString("type");
                String data = resultSet.getString("data");
                String signature = resultSet.getString("signature");
                ID identifier = ID.parse((Object)did);
                assert (identifier != null) : "did error: " + did;
                if (type == null || type.length() == 0) {
                    type = "*";
                }
                Document doc = Document.create((String)type, (ID)identifier, (String)data, (String)signature);
                if (type.equals("*")) {
                    type = identifier.isGroup() ? "bulletin" : "visa";
                }
                doc.put((Object)"type", (Object)type);
                return doc;
            };
        }
        return true;
    }

    public Document getDocument(ID entity, String type) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", entity.toString());
        List results = this.select(T_DOCUMENT, SELECT_COLUMNS, conditions, null, null, "id DESC", -1, 0);
        return results == null || results.size() == 0 ? null : (Document)results.get(0);
    }

    public boolean saveDocument(Document doc) {
        if (!this.prepare()) {
            return false;
        }
        ID identifier = doc.getIdentifier();
        String type = doc.getType();
        String data = doc.getString("data");
        String signature = doc.getString("signature");
        Document old = this.getDocument(identifier, type);
        if (old == null) {
            Object[] values = new Object[]{identifier.toString(), type, data, signature};
            return this.insert(T_DOCUMENT, INSERT_COLUMNS, values) > 0;
        }
        if (old.get((Object)"data").equals(data) && old.get((Object)"signature").equals(signature)) {
            return true;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", identifier.toString());
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("type", type);
        values.put("data", data);
        values.put("signature", signature);
        return this.update(T_DOCUMENT, values, conditions) > 0;
    }
}

