/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.MetaDBI;
import chat.dim.format.JSON;
import chat.dim.protocol.ID;
import chat.dim.protocol.Meta;
import chat.dim.protocol.MetaType;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import java.util.HashMap;
import java.util.List;

public class MetaTable
extends DataTableHandler<Meta>
implements MetaDBI {
    private DataRowExtractor<Meta> extractor = null;
    private static final String[] SELECT_COLUMNS = new String[]{"type", "pub_key", "seed", "fingerprint"};
    private static final String[] INSERT_COLUMNS = new String[]{"did", "type", "pub_key", "seed", "fingerprint"};
    private static final String T_META = "t_meta";

    public MetaTable(DatabaseConnector connector) {
        super(connector);
    }

    @Override
    protected DataRowExtractor<Meta> getDataRowExtractor() {
        return this.extractor;
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "did VARCHAR(64)", "type INTEGER", "pub_key TEXT", "seed VARCHAR(20)", "fingerprint VARCHAR(88)"};
            if (!this.createTable(T_META, fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                int type = resultSet.getInt("type");
                String json = resultSet.getString("pub_key");
                Object key = JSON.decode((String)json);
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("version", type);
                info.put("type", type);
                info.put("key", key);
                if (MetaType.hasSeed((int)type)) {
                    String seed = resultSet.getString("seed");
                    String fingerprint = resultSet.getString("fingerprint");
                    info.put("seed", seed);
                    info.put("fingerprint", fingerprint);
                }
                return Meta.parse(info);
            };
        }
        return true;
    }

    public Meta getMeta(ID entity) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", entity.toString());
        List results = this.select(T_META, SELECT_COLUMNS, conditions, null, null, "id DESC", -1, 0);
        return results == null || results.size() == 0 ? null : (Meta)results.get(0);
    }

    public boolean saveMeta(Meta meta, ID entity) {
        String fingerprint;
        String seed;
        if (!this.prepare()) {
            return false;
        }
        Meta old = this.getMeta(entity);
        if (old != null) {
            return false;
        }
        int type = meta.getType();
        String json = JSON.encode((Object)meta.getKey());
        if (MetaType.hasSeed((int)type)) {
            seed = meta.getSeed();
            fingerprint = meta.getString("fingerprint");
        } else {
            seed = "";
            fingerprint = "";
        }
        Object[] values = new Object[]{entity.toString(), type, json, seed, fingerprint};
        return this.insert(T_META, INSERT_COLUMNS, values) > 0;
    }
}

