/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sql;

import chat.dim.type.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SQLValues {
    private final List<Pair<String, Object>> valueList = new ArrayList<Pair<String, Object>>();

    public void setValue(String name, Object value) {
        Pair pair;
        int index;
        for (index = this.valueList.size() - 1; index >= 0; --index) {
            pair = this.valueList.get(index);
            if (name.equals(pair.first)) break;
        }
        pair = new Pair((Object)name, value);
        if (index < 0) {
            this.valueList.add((Pair<String, Object>)pair);
        } else {
            this.valueList.set(index, (Pair<String, Object>)pair);
        }
    }

    void appendValues(StringBuilder sb) {
        for (Pair<String, Object> pair : this.valueList) {
            sb.append((String)pair.first);
            sb.append("=");
            SQLValues.appendEscapeValue(sb, pair.second);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    static void appendEscapeValue(StringBuilder sb, Object value) {
        if (value instanceof Number) {
            sb.append(value);
        } else if (value instanceof String) {
            SQLValues.appendEscapeString(sb, (String)value);
        } else {
            SQLValues.appendEscapeString(sb, value.toString());
        }
    }

    private static void appendEscapeString(StringBuilder sb, String sql) {
        sb.append('\'');
        if (sql.indexOf(39) != -1) {
            int count = sql.length();
            for (int index = 0; index < count; ++index) {
                char ch = sql.charAt(index);
                if (ch == '\'') {
                    sb.append('\'');
                }
                sb.append(ch);
            }
        } else {
            sb.append(sql);
        }
        sb.append('\'');
    }

    static void appendEscapeValueList(StringBuilder sb, Object[] array) {
        for (Object item : array) {
            SQLValues.appendEscapeValue(sb, item);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    static void appendStringList(StringBuilder sb, String[] array) {
        for (String item : array) {
            sb.append(item);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    static SQLValues from(Map<String, Object> values) {
        SQLValues sqlValues = new SQLValues();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            sqlValues.setValue(entry.getKey(), entry.getValue());
        }
        return sqlValues;
    }
}

