/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.crypto.PlainKey;
import chat.dim.crypto.SymmetricKey;
import chat.dim.dbi.CipherKeyDBI;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.ID;
import chat.dim.sqlite.DatabaseConnector;

public class CipherKeyDatabase
implements CipherKeyDBI {
    private final CachePool<String, SymmetricKey> keyCache;

    public CipherKeyDatabase(DatabaseConnector sqliteConnector) {
        CacheManager man = CacheManager.getInstance();
        this.keyCache = man.getPool("cipher_key");
    }

    public SymmetricKey getCipherKey(ID sender, ID receiver, boolean generate) {
        SymmetricKey key;
        if (receiver.isBroadcast()) {
            return PlainKey.getInstance();
        }
        long now = System.currentTimeMillis();
        CachePair pair = this.keyCache.fetch((Object)(sender + "->" + receiver), now);
        SymmetricKey symmetricKey = key = pair == null ? null : (SymmetricKey)pair.value;
        if (key == null && generate) {
            key = SymmetricKey.generate((String)"AES");
            assert (key != null) : "failed to generate symmetric key";
            this.keyCache.update((Object)(sender + "->" + receiver), (Object)key, 604800000L, now);
        }
        return key;
    }

    public void cacheCipherKey(ID sender, ID receiver, SymmetricKey key) {
        this.keyCache.update((Object)(sender + "->" + receiver), (Object)key, 604800000L, 0L);
    }
}

