/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sql;

import chat.dim.sql.SQLConditions;
import chat.dim.sql.SQLValues;
import java.util.Map;

public final class SQLBuilder {
    public static final String CREATE = "CREATE";
    public static final String ALTER = "ALTER";
    public static final String INSERT = "INSERT";
    public static final String SELECT = "SELECT";
    public static final String UPDATE = "UPDATE";
    public static final String DELETE = "DELETE";
    private final StringBuilder sb = new StringBuilder(128);

    public SQLBuilder(String sql) {
        this.append(sql);
    }

    public String toString() {
        return this.sb.toString();
    }

    private void append(String str) {
        this.sb.append(str);
    }

    private void appendStringList(String[] array) {
        SQLValues.appendStringList(this.sb, array);
    }

    private void appendEscapeValueList(Object[] array) {
        SQLValues.appendEscapeValueList(this.sb, array);
    }

    private void appendValues(SQLValues values) {
        values.appendValues(this.sb);
    }

    private void appendColumns(String[] columns) {
        if (columns == null || columns.length == 0) {
            this.append(" *");
        } else {
            this.append(" ");
            this.appendStringList(columns);
        }
    }

    private void appendClause(String name, String clause) {
        if (clause == null || clause.length() == 0) {
            return;
        }
        this.append(name);
        this.append(clause);
    }

    private void appendWhere(SQLConditions conditions) {
        if (conditions == null) {
            return;
        }
        this.append(" WHERE ");
        conditions.appendEscapeValue(this.sb);
    }

    public static String buildCreateTable(String table, String[] fields) {
        SQLBuilder builder = new SQLBuilder(CREATE);
        builder.append(" TABLE IF NOT EXISTS ");
        builder.append(table);
        builder.append("(");
        builder.appendStringList(fields);
        builder.append(")");
        return builder.toString();
    }

    public static String buildCreateIndex(String name, String table, String[] fields) {
        SQLBuilder builder = new SQLBuilder(CREATE);
        builder.append(" INDEX IF NOT EXISTS ");
        builder.append(name);
        builder.append(" ON ");
        builder.append(table);
        builder.append("(");
        builder.appendStringList(fields);
        builder.append(")");
        return builder.toString();
    }

    public static String buildAddColumn(String table, String name, String type) {
        SQLBuilder builder = new SQLBuilder(ALTER);
        builder.append(" TABLE ");
        builder.append(table);
        builder.append(" ADD COLUMN ");
        builder.append(name);
        builder.append(" ");
        builder.append(type);
        return builder.toString();
    }

    public static String buildInsert(String table, String[] columns, Object[] values) {
        SQLBuilder builder = new SQLBuilder(INSERT);
        builder.append(" INTO ");
        builder.append(table);
        builder.append("(");
        builder.appendStringList(columns);
        builder.append(") VALUES (");
        builder.appendEscapeValueList(values);
        builder.append(")");
        return builder.toString();
    }

    public static String buildSelect(boolean distinct, String[] columns, String table, SQLConditions conditions, String groupBy, String having, String orderBy, int limit, int offset) {
        SQLBuilder builder = new SQLBuilder(SELECT);
        if (distinct) {
            builder.append(" DISTINCT");
        }
        builder.appendColumns(columns);
        builder.append(" FROM ");
        builder.append(table);
        builder.appendWhere(conditions);
        builder.appendClause(" GROUP BY ", groupBy);
        builder.appendClause(" HAVING ", having);
        builder.appendClause(" ORDER BY ", orderBy);
        if (limit > 0) {
            builder.appendClause(" LIMIT ", String.valueOf(limit));
            builder.appendClause(" OFFSET ", String.valueOf(offset));
        }
        return builder.toString();
    }

    public static String buildUpdate(String table, Map<String, Object> values, SQLConditions conditions) {
        SQLBuilder builder = new SQLBuilder(UPDATE);
        builder.append(" ");
        builder.append(table);
        builder.append(" SET ");
        builder.appendValues(SQLValues.from(values));
        builder.appendWhere(conditions);
        return builder.toString();
    }

    public static String buildDelete(String table, SQLConditions conditions) {
        SQLBuilder builder = new SQLBuilder(DELETE);
        builder.append(" FROM ");
        builder.append(table);
        builder.appendWhere(conditions);
        return builder.toString();
    }
}

