/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.DocumentDBI;
import chat.dim.format.TransportableData;
import chat.dim.protocol.Document;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import java.util.HashMap;
import java.util.List;

public class DocumentTable
extends DataTableHandler<Document>
implements DocumentDBI {
    private DataRowExtractor<Document> extractor = null;
    private static final String[] SELECT_COLUMNS = new String[]{"did", "type", "data", "signature"};
    private static final String[] INSERT_COLUMNS = new String[]{"did", "type", "data", "signature"};
    private static final String T_DOCUMENT = "t_document";

    public DocumentTable(DatabaseConnector connector) {
        super(connector);
    }

    @Override
    protected DataRowExtractor<Document> getDataRowExtractor() {
        return this.extractor;
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "did VARCHAR(64)", "type VARCHAR(8)", "data TEXT", "signature VARCHAR(88)"};
            if (!this.createTable(T_DOCUMENT, fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                Document doc;
                String did = resultSet.getString("did");
                String type = resultSet.getString("type");
                String data = resultSet.getString("data");
                String signature = resultSet.getString("signature");
                ID identifier = ID.parse((Object)did);
                assert (identifier != null) : "did error: " + did;
                if (type == null || type.length() == 0) {
                    type = "*";
                }
                if (data == null || signature == null) {
                    doc = Document.create((String)type, (ID)identifier);
                } else {
                    TransportableData ted = TransportableData.parse((Object)signature);
                    assert (ted != null) : "signature error: " + signature;
                    doc = Document.create((String)type, (ID)identifier, (String)data, (TransportableData)ted);
                }
                if (type.equals("*")) {
                    type = identifier.isGroup() ? "bulletin" : "visa";
                }
                doc.put((Object)"type", (Object)type);
                return doc;
            };
        }
        return true;
    }

    public List<Document> getDocuments(ID identifier) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", identifier.toString());
        return this.select(T_DOCUMENT, SELECT_COLUMNS, conditions, null, null, "id DESC", -1, 0);
    }

    public boolean saveDocument(Document doc) {
        List<Document> documents;
        ID identifier = doc.getIdentifier();
        String type = doc.getType();
        if (type == null) {
            type = "";
        }
        if ((documents = this.getDocuments(identifier)) != null) {
            for (Document item : documents) {
                if (!identifier.equals(item.getIdentifier()) || !type.equals(item.getType())) continue;
                return this.updateDocument(doc);
            }
        }
        return this.insertDocument(doc);
    }

    protected boolean updateDocument(Document doc) {
        if (!this.prepare()) {
            return false;
        }
        ID identifier = doc.getIdentifier();
        String type = doc.getType();
        String data = doc.getString("data", "");
        String signature = doc.getString("signature", "");
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "did", "=", identifier.toString());
        conditions.addCondition(SQLConditions.Relation.AND, "type", "=", type);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("data", data);
        values.put("signature", signature);
        return this.update(T_DOCUMENT, values, conditions) > 0;
    }

    protected boolean insertDocument(Document doc) {
        if (!this.prepare()) {
            return false;
        }
        ID identifier = doc.getIdentifier();
        String type = doc.getType();
        String data = doc.getString("data", "");
        String signature = doc.getString("signature", "");
        Object[] values = new Object[]{identifier.toString(), type, data, signature};
        return this.insert(T_DOCUMENT, INSERT_COLUMNS, values) > 0;
    }
}

