/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.crypto.DecryptKey;
import chat.dim.crypto.PrivateKey;
import chat.dim.dbi.PrivateKeyDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.ID;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.PrivateKeyTable;
import java.util.ArrayList;
import java.util.List;

public class PrivateKeyDatabase
implements PrivateKeyDBI {
    private final PrivateKeyTable privateKeyTable;
    private final CachePool<ID, PrivateKey> idKeyCache;
    private final CachePool<ID, List<DecryptKey>> msgKeysCache;

    public PrivateKeyDatabase(DatabaseConnector sqliteConnector) {
        this.privateKeyTable = new PrivateKeyTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.idKeyCache = man.getPool("private_id_key");
        this.msgKeysCache = man.getPool("private_msg_keys");
    }

    public boolean savePrivateKey(PrivateKey key, String type, ID user) {
        long now = System.currentTimeMillis();
        if (type != null && type.equals("M")) {
            this.idKeyCache.update((Object)user, (Object)key, 36000000L, now);
        } else {
            List decryptKeys = this.getPrivateKeysForDecryption(user);
            List privateKeys = PrivateKeyDBI.convertPrivateKeys(decryptKeys);
            if ((privateKeys = PrivateKeyDBI.insertKey((PrivateKey)key, (List)privateKeys)) == null) {
                return false;
            }
            decryptKeys = PrivateKeyDBI.convertDecryptKeys((Iterable)privateKeys);
            this.msgKeysCache.update((Object)user, (Object)decryptKeys, 36000000L, now);
        }
        return this.privateKeyTable.savePrivateKey(key, type, user);
    }

    public List<DecryptKey> getPrivateKeysForDecryption(ID user) {
        long now = System.currentTimeMillis();
        List<DecryptKey> decryptKeys = null;
        CacheHolder holder = null;
        CachePair pair = this.msgKeysCache.fetch((Object)user, now);
        if (pair != null) {
            decryptKeys = (List<DecryptKey>)pair.value;
            holder = pair.holder;
        }
        if (decryptKeys == null) {
            if (holder == null) {
                this.msgKeysCache.update((Object)user, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return new ArrayList<DecryptKey>();
                }
                holder.renewal(128000L, now);
            }
            decryptKeys = this.privateKeyTable.getPrivateKeysForDecryption(user);
            if (decryptKeys == null) {
                decryptKeys = new ArrayList<DecryptKey>();
            }
            this.msgKeysCache.update((Object)user, decryptKeys, 36000000L, now);
        }
        return decryptKeys;
    }

    public PrivateKey getPrivateKeyForSignature(ID user) {
        return this.getPrivateKeyForVisaSignature(user);
    }

    public PrivateKey getPrivateKeyForVisaSignature(ID user) {
        long now = System.currentTimeMillis();
        PrivateKey privateKey = null;
        CacheHolder holder = null;
        CachePair pair = this.idKeyCache.fetch((Object)user, now);
        if (pair != null) {
            privateKey = (PrivateKey)pair.value;
            holder = pair.holder;
        }
        if (privateKey == null) {
            if (holder == null) {
                this.idKeyCache.update((Object)user, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            privateKey = this.privateKeyTable.getPrivateKeyForVisaSignature(user);
            this.idKeyCache.update((Object)user, (Object)privateKey, 36000000L, now);
        }
        return privateKey;
    }
}

