/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.ContactDBI;
import chat.dim.protocol.ID;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import java.util.List;

public class ContactTable
extends DataTableHandler<ID>
implements ContactDBI {
    private DataRowExtractor<ID> extractor = null;
    private static final String[] SELECT_COLUMNS = new String[]{"contact"};
    private static final String[] INSERT_COLUMNS = new String[]{"user", "contact"};
    private static final String T_CONTACT = "t_contact";

    public ContactTable(DatabaseConnector connector) {
        super(connector);
    }

    @Override
    protected DataRowExtractor<ID> getDataRowExtractor() {
        return this.extractor;
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "user VARCHAR(64)", "contact VARCHAR(64)", "alias VARCHAR(32))"};
            if (!this.createTable(T_CONTACT, fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String did = resultSet.getString("contact");
                return ID.parse((Object)did);
            };
        }
        return true;
    }

    public List<ID> getContacts(ID user) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", user.toString());
        return this.select(T_CONTACT, SELECT_COLUMNS, conditions);
    }

    public boolean saveContacts(List<ID> contacts, ID user) {
        List<ID> oldContacts = this.getContacts(user);
        if (oldContacts == null) {
            return false;
        }
        for (ID identifier : oldContacts) {
            if (contacts.contains(identifier)) continue;
            SQLConditions conditions = new SQLConditions();
            conditions.addCondition(null, "user", "=", user.toString());
            conditions.addCondition(SQLConditions.Relation.AND, "contact", "=", identifier.toString());
            if (this.delete(T_CONTACT, conditions) >= 0) continue;
            return false;
        }
        for (ID identifier : contacts) {
            if (oldContacts.contains(identifier)) continue;
            Object[] values = new Object[]{user.toString(), identifier.toString()};
            if (this.insert(T_CONTACT, INSERT_COLUMNS, values) >= 0) continue;
            return false;
        }
        return true;
    }
}

