/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.dbi.DocumentDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.Document;
import chat.dim.protocol.ID;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.DocumentTable;
import java.util.List;

public class DocumentDatabase
implements DocumentDBI {
    private final DocumentTable documentTable;
    private final CachePool<ID, List<Document>> documentCache;

    public DocumentDatabase(DatabaseConnector sqliteConnector) {
        this.documentTable = new DocumentTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.documentCache = man.getPool("document");
    }

    public boolean saveDocument(Document doc, ID entity) {
        assert (entity.equals(doc.get((Object)"did"))) : " document ID not matched: " + entity + ", " + doc;
        this.documentCache.erase((Object)entity, 0L);
        return this.documentTable.saveDocument(doc, entity);
    }

    public List<Document> getDocuments(ID entity) {
        long now = System.currentTimeMillis();
        List<Document> documents = null;
        CacheHolder holder = null;
        CachePair pair = this.documentCache.fetch((Object)entity, now);
        if (pair != null) {
            documents = (List<Document>)pair.value;
            holder = pair.holder;
        }
        if (documents == null) {
            if (holder == null) {
                this.documentCache.update((Object)entity, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            documents = this.documentTable.getDocuments(entity);
            this.documentCache.update((Object)entity, documents, 36000000L, now);
        }
        return documents;
    }
}

