/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.dbi.GroupDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.ID;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.GroupTable;
import java.util.ArrayList;
import java.util.List;

public class GroupDatabase
implements GroupDBI {
    private final GroupTable groupTable;
    private final CachePool<ID, ID> founderCache;
    private final CachePool<ID, ID> ownerCache;
    private final CachePool<ID, List<ID>> membersCache;

    public GroupDatabase(DatabaseConnector sqliteConnector) {
        this.groupTable = new GroupTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.founderCache = man.getPool("founder");
        this.ownerCache = man.getPool("owner");
        this.membersCache = man.getPool("members");
    }

    public ID getFounder(ID group) {
        long now = System.currentTimeMillis();
        ID value = null;
        CacheHolder holder = null;
        CachePair pair = this.founderCache.fetch((Object)group, now);
        if (pair != null) {
            value = (ID)pair.value;
            holder = pair.holder;
        }
        if (value == null) {
            if (holder == null) {
                this.founderCache.update((Object)group, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            value = this.groupTable.getFounder(group);
            if (value == null) {
                value = ID.FOUNDER;
            }
            this.founderCache.update((Object)group, (Object)value, 36000000L, now);
        } else if (value.isBroadcast()) {
            value = null;
        }
        return value;
    }

    public ID getOwner(ID group) {
        long now = System.currentTimeMillis();
        ID value = null;
        CacheHolder holder = null;
        CachePair pair = this.ownerCache.fetch((Object)group, now);
        if (pair != null) {
            value = (ID)pair.value;
            holder = pair.holder;
        }
        if (value == null) {
            if (holder == null) {
                this.ownerCache.update((Object)group, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            value = this.groupTable.getOwner(group);
            if (value == null) {
                value = ID.ANYONE;
            }
            this.ownerCache.update((Object)group, (Object)value, 3600000L, now);
        } else if (value.isBroadcast()) {
            value = null;
        }
        return value;
    }

    public List<ID> getMembers(ID group) {
        long now = System.currentTimeMillis();
        List<ID> value = null;
        CacheHolder holder = null;
        CachePair pair = this.membersCache.fetch((Object)group, now);
        if (pair != null) {
            value = (List<ID>)pair.value;
            holder = pair.holder;
        }
        if (value == null) {
            if (holder == null) {
                this.membersCache.update((Object)group, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return new ArrayList<ID>();
                }
                holder.renewal(128000L, now);
            }
            value = this.groupTable.getMembers(group);
            if (value == null) {
                value = new ArrayList<ID>();
            }
            this.membersCache.update((Object)group, value, 3600000L, now);
        }
        return value;
    }

    public boolean saveMembers(List<ID> members, ID group) {
        long now = System.currentTimeMillis();
        this.membersCache.update((Object)group, members, 3600000L, now);
        return this.groupTable.saveMembers(members, group);
    }

    public List<ID> getAdministrators(ID group) {
        return null;
    }

    public boolean saveAdministrators(List<ID> members, ID group) {
        return false;
    }
}

