/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.database;

import chat.dim.dbi.MetaDBI;
import chat.dim.mem.CacheHolder;
import chat.dim.mem.CacheManager;
import chat.dim.mem.CachePair;
import chat.dim.mem.CachePool;
import chat.dim.protocol.ID;
import chat.dim.protocol.Meta;
import chat.dim.sqlite.DatabaseConnector;
import chat.dim.sqlite.account.MetaTable;

public class MetaDatabase
implements MetaDBI {
    private final MetaTable metaTable;
    private final CachePool<ID, Meta> metaCache;

    public MetaDatabase(DatabaseConnector sqliteConnector) {
        this.metaTable = new MetaTable(sqliteConnector);
        CacheManager man = CacheManager.getInstance();
        this.metaCache = man.getPool("meta");
    }

    public boolean saveMeta(Meta meta, ID entity) {
        Meta old = this.getMeta(entity);
        if (old != null) {
            return true;
        }
        this.metaCache.update((Object)entity, (Object)meta, 36000000L, 0L);
        return this.metaTable.saveMeta(meta, entity);
    }

    public Meta getMeta(ID entity) {
        long now = System.currentTimeMillis();
        Meta meta = null;
        CacheHolder holder = null;
        CachePair pair = this.metaCache.fetch((Object)entity, now);
        if (pair != null) {
            meta = (Meta)pair.value;
            holder = pair.holder;
        }
        if (meta == null) {
            if (holder == null) {
                this.metaCache.update((Object)entity, null, 128000L, now);
            } else {
                if (holder.isAlive(now)) {
                    return null;
                }
                holder.renewal(128000L, now);
            }
            meta = this.metaTable.getMeta(entity);
            this.metaCache.update((Object)entity, (Object)meta, 36000000L, now);
        }
        return meta;
    }
}

