/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sql;

import chat.dim.sql.SQLValues;

public final class SQLConditions {
    private Condition condition = null;

    public void appendEscapeValue(StringBuilder sb) {
        if (this.condition != null) {
            this.condition.appendEscapeValue(sb);
        }
    }

    public void addCondition(Relation relation, String name, String operator, Object value) {
        Condition newCondition = SQLConditions.createCondition(name, operator, value);
        this.addCondition(relation, newCondition);
    }

    private void addCondition(Relation relation, Condition newCondition) {
        this.condition = this.condition == null ? newCondition : SQLConditions.createCondition(this.condition, relation, newCondition);
    }

    private static Condition createCondition(String name, String operator, Object value) {
        return new CompareCondition(name, operator, value);
    }

    private static Condition createCondition(Condition left, Relation relation, Condition right) {
        return new RelatedCondition(left, relation, right);
    }

    public static interface Condition {
        public void appendEscapeValue(StringBuilder var1);
    }

    public static enum Relation {
        AND,
        OR;

    }

    static final class CompareCondition
    implements Condition {
        private final String name;
        private final String operator;
        private final Object value;

        CompareCondition(String left, String op, Object right) {
            this.name = left;
            this.operator = op;
            this.value = right;
        }

        @Override
        public void appendEscapeValue(StringBuilder sb) {
            sb.append(this.name);
            sb.append(this.operator);
            SQLValues.appendEscapeValue(sb, this.value);
        }
    }

    static final class RelatedCondition
    implements Condition {
        private final Condition condition1;
        private final Relation relation;
        private final Condition condition2;

        RelatedCondition(Condition left, Relation op, Condition right) {
            this.condition1 = left;
            this.relation = op;
            this.condition2 = right;
        }

        private static void appendEscapeValue(StringBuilder sb, Condition condition) {
            if (condition instanceof RelatedCondition) {
                sb.append("(");
                condition.appendEscapeValue(sb);
                sb.append(")");
            } else {
                condition.appendEscapeValue(sb);
            }
        }

        @Override
        public void appendEscapeValue(StringBuilder sb) {
            RelatedCondition.appendEscapeValue(sb, this.condition1);
            switch (this.relation) {
                case AND: {
                    sb.append(" AND ");
                    break;
                }
                case OR: {
                    sb.append(" OR ");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("relation operator error: " + (Object)((Object)this.relation)));
                }
            }
            RelatedCondition.appendEscapeValue(sb, this.condition2);
        }
    }
}

