/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.sqlite.account;

import chat.dim.dbi.PrivateKeyDBI;
import chat.dim.format.JSON;
import chat.dim.protocol.DecryptKey;
import chat.dim.protocol.ID;
import chat.dim.protocol.PrivateKey;
import chat.dim.sql.SQLConditions;
import chat.dim.sqlite.DataRowExtractor;
import chat.dim.sqlite.DataTableHandler;
import chat.dim.sqlite.DatabaseConnector;
import java.util.List;

public class PrivateKeyTable
extends DataTableHandler<PrivateKey>
implements PrivateKeyDBI {
    private DataRowExtractor<PrivateKey> extractor = null;
    private static final String[] SELECT_COLUMNS = new String[]{"pri_key"};
    private static final String[] INSERT_COLUMNS = new String[]{"user", "pri_key", "type", "sign", "decrypt"};
    private static final String T_PRIVATE_KEY = "t_private_key";

    public PrivateKeyTable(DatabaseConnector connector) {
        super(connector);
    }

    @Override
    protected DataRowExtractor<PrivateKey> getDataRowExtractor() {
        return this.extractor;
    }

    private boolean prepare() {
        if (this.extractor == null) {
            String[] fields = new String[]{"id INTEGER PRIMARY KEY AUTOINCREMENT", "user VARCHAR(64)", "pri_key TEXT", "type CHAR(1)", "sign BIT", "decrypt BIT"};
            if (!this.createTable(T_PRIVATE_KEY, fields)) {
                return false;
            }
            this.extractor = (resultSet, index) -> {
                String json = resultSet.getString("pri_key");
                Object key = JSON.decode((String)json);
                return PrivateKey.parse((Object)key);
            };
        }
        return true;
    }

    public List<DecryptKey> getPrivateKeysForDecryption(ID user) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", user.toString());
        conditions.addCondition(SQLConditions.Relation.AND, "decrypt", "=", 1);
        List results = this.select(T_PRIVATE_KEY, SELECT_COLUMNS, conditions, null, null, "type DESC", 3, 0);
        if (results == null) {
            return null;
        }
        return PrivateKeyDBI.convertDecryptKeys(results);
    }

    public PrivateKey getPrivateKeyForSignature(ID user) {
        return this.getPrivateKeyForVisaSignature(user);
    }

    public PrivateKey getPrivateKeyForVisaSignature(ID user) {
        if (!this.prepare()) {
            return null;
        }
        SQLConditions conditions = new SQLConditions();
        conditions.addCondition(null, "user", "=", user.toString());
        conditions.addCondition(SQLConditions.Relation.AND, "type", "=", "M");
        conditions.addCondition(SQLConditions.Relation.AND, "sign", "=", 1);
        List results = this.select(T_PRIVATE_KEY, SELECT_COLUMNS, conditions, null, null, "id DESC", 1, 0);
        return results == null || results.size() == 0 ? null : (PrivateKey)results.get(0);
    }

    private boolean savePrivateKey(ID user, PrivateKey key, String type, int sign, int decrypt) {
        if (!this.prepare()) {
            return false;
        }
        String json = JSON.encode((Object)key);
        Object[] values = new Object[]{user.toString(), json, type, sign, decrypt};
        return this.insert(T_PRIVATE_KEY, INSERT_COLUMNS, values) > 0;
    }

    public boolean savePrivateKey(PrivateKey key, String type, ID user) {
        if (key instanceof DecryptKey) {
            return this.savePrivateKey(user, key, type, 1, 1);
        }
        return this.savePrivateKey(user, key, type, 1, 0);
    }
}

