/*
 * Decompiled with CFR 0.152.
 */
package cloud.opencode.base.basecode;

import cloud.opencode.base.basecode.enums.ResultMessageEnum;
import cloud.opencode.base.basecode.enums.ResultStatusEnum;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CodeResult<T>
extends ResponseEntity<T>
implements Serializable {
    private static final long serialVersionUID = -877545005334587795L;
    private T data;
    private Integer code;
    private String message;
    private Long total;
    private Long page;
    private Long pageSize;

    public CodeResult(HttpStatusCode status) {
        super(status);
        this.data = null;
        this.code = ResultStatusEnum.SUCCESS.getCode();
        this.message = ResultMessageEnum.SYSTEM_OK.getValue();
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, HttpStatusCode status) {
        super(body, status);
        this.data = body;
        this.code = null;
        this.message = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, HttpStatusCode status, @Nullable Integer code) {
        super(body, status);
        this.data = body;
        this.code = code;
        this.message = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable MultiValueMap<String, String> headers, HttpStatusCode status) {
        super(headers, status);
        this.data = null;
        this.code = null;
        this.message = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, MultiValueMap<String, String> headers, int rawStatus) {
        super(body, headers, rawStatus);
        this.data = body;
        this.code = null;
        this.message = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, MultiValueMap<String, String> headers, HttpStatusCode statusCode) {
        super(body, headers, statusCode);
        this.data = body;
        this.code = null;
        this.message = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, HttpStatusCode status, @Nullable String message) {
        super(body, status);
        this.data = body;
        this.message = message;
        this.code = null;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, HttpStatusCode status, @Nullable String message, @Nullable Integer code) {
        super(body, status);
        this.data = body;
        this.message = message;
        this.code = code;
        this.total = null;
        this.page = null;
        this.pageSize = null;
    }

    public CodeResult(@Nullable T body, HttpStatusCode status, @Nullable String message, @Nullable Long total, @Nullable Long page, @Nullable Long pageSize) {
        super(body, status);
        this.data = body;
        this.message = message;
        this.total = total;
        this.page = page;
        this.pageSize = pageSize;
    }

    public CodeResult(@Nullable T body, HttpStatusCode status, @Nullable String message, @Nullable Long total, @Nullable Long page, @Nullable Long pageSize, @Nullable Integer code) {
        super(body, status);
        this.data = body;
        this.message = message;
        this.total = total;
        this.page = page;
        this.pageSize = pageSize;
        this.code = code;
    }

    public static CodeResult OK() {
        return new CodeResult(HttpStatusCode.valueOf((int)200));
    }

    public static <T> CodeResult OK(T data) {
        return new CodeResult<T>(data, HttpStatusCode.valueOf((int)200), ResultMessageEnum.SYSTEM_SUCCESS.getValue(), ResultStatusEnum.SUCCESS.getCode());
    }

    public static <T> CodeResult OK(T data, String message) {
        return new CodeResult<T>(data, HttpStatusCode.valueOf((int)200), message, ResultStatusEnum.SUCCESS.getCode());
    }

    public static <T> CodeResult OK(T data, String message, Integer code) {
        return new CodeResult<T>(data, HttpStatusCode.valueOf((int)200), message, code);
    }

    public static <T> CodeResult OK(T data, String message, Long total, Long page, Long pageSize) {
        return new CodeResult<T>(data, HttpStatusCode.valueOf((int)200), message, total, page, pageSize);
    }

    public static <T> CodeResult OK(T data, String message, Long total, Long page, Long pageSize, Integer code) {
        return new CodeResult<T>(data, HttpStatusCode.valueOf((int)200), message, total, page, pageSize, code);
    }

    public static CodeResult OK(String message, Integer code) {
        return new CodeResult<Object>(null, HttpStatusCode.valueOf((int)200), message, code);
    }

    public static <T> CodeResult OK(@Nullable T body, MultiValueMap<String, String> headers, int rawStatus) {
        return new CodeResult<T>(body, headers, rawStatus);
    }

    public static CodeResult OK(@Nullable MultiValueMap<String, String> headers, HttpStatusCode status) {
        return new CodeResult(headers, HttpStatusCode.valueOf((int)status.value()));
    }

    public static <T> CodeResult OK(@Nullable T body, MultiValueMap<String, String> headers, HttpStatusCode statusCode) {
        return new CodeResult<T>(body, headers, statusCode);
    }

    public static CodeResult ERROR(String message, HttpStatus status) {
        return new CodeResult<Object>(null, HttpStatusCode.valueOf((int)status.value()), (Integer)ResultStatusEnum.FAIL.getCode());
    }

    public static CodeResult ERROR(String message) {
        return new CodeResult<Object>(null, HttpStatusCode.valueOf((int)400), message, ResultStatusEnum.FAIL.getCode());
    }

    public T getData() {
        return this.data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setPage(Long page) {
        this.page = page;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }
}

