/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIField;
import cn.schoolwow.quickapi.domain.APIHistory;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.handler.Handler;
import cn.schoolwow.quickapi.util.QuickAPIConfig;
import cn.schoolwow.quickapi.util.QuickAPIUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickAPI {
    private static Logger logger = LoggerFactory.getLogger(QuickAPI.class);
    private static Handler[] handlers;

    public static QuickAPI newInstance() {
        return new QuickAPI();
    }

    private QuickAPI() {
    }

    public QuickAPI title(String title) {
        QuickAPIConfig.apiDocument.title = title;
        return this;
    }

    public QuickAPI description(String description) {
        QuickAPIConfig.apiDocument.description = description;
        return this;
    }

    public QuickAPI controller(String packageName) {
        QuickAPIConfig.controllerPackageNameList.add(packageName);
        return this;
    }

    public QuickAPI controllerClass(String className) {
        QuickAPIConfig.controllerClassNameList.add(className);
        return this;
    }

    public QuickAPI prefix(String prefix) {
        if (null == prefix || prefix.isEmpty()) {
            return this;
        }
        if (!prefix.startsWith("/")) {
            prefix = "/" + prefix;
        }
        QuickAPIConfig.prefix = prefix;
        return this;
    }

    public QuickAPI url(String url) {
        QuickAPIConfig.url = url;
        return this;
    }

    public QuickAPI directory(String directory) {
        QuickAPIConfig.directory = directory;
        return this;
    }

    public QuickAPI sourcePath(String sourcePath) {
        if (Files.notExists(Paths.get(sourcePath, new String[0]), new LinkOption[0])) {
            logger.warn("[\u6e90\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728]\u8def\u5f84:{}", (Object)sourcePath);
            return this;
        }
        QuickAPIConfig.sourcePathBuilder.append(sourcePath + ";");
        return this;
    }

    public QuickAPI classPath(URL classPathURL) {
        QuickAPIConfig.classPathList.add(classPathURL);
        return this;
    }

    public QuickAPI lib(String libDirectory) throws IOException {
        Files.walkFileTree(Paths.get(libDirectory, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().endsWith(".jar")) {
                    QuickAPI.this.classPath(file.toUri().toURL());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return this;
    }

    public QuickAPI ignorePackageName(String ignorePackageName) {
        QuickAPIConfig.ignorePackageNameList.add(ignorePackageName);
        return this;
    }

    public QuickAPI ignoreClass(String ignoreClassName) {
        QuickAPIConfig.ignoreClassList.add(ignoreClassName);
        return this;
    }

    public QuickAPI filter(Predicate<String> predicate) {
        QuickAPIConfig.predicate = predicate;
        return this;
    }

    public QuickAPI generate() {
        try {
            QuickAPIUtil.initClassPath();
            Set<String> classNameSet = QuickAPIUtil.scanControllerPackage();
            ArrayList<APIController> apiControllerList = new ArrayList<APIController>(classNameSet.size());
            for (Handler handler : handlers) {
                if (!handler.exist() || !handler.isControllerEnvironment()) continue;
                for (String className : classNameSet) {
                    try {
                        Class<?> clazz = QuickAPIConfig.urlClassLoader.loadClass(className);
                        APIController apiController = handler.getApiController(clazz);
                        if (null == apiController) continue;
                        apiControllerList.add(apiController);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            for (Handler handler : handlers) {
                if (!handler.exist()) continue;
                for (APIController apiController : apiControllerList) {
                    handler.handleController(apiController);
                    if (null != apiController.clazz.getAnnotation(Deprecated.class)) {
                        apiController.deprecated = true;
                    }
                    for (API api : apiController.apiList) {
                        handler.handleAPI(api);
                        if (null == api.method.getAnnotation(Deprecated.class)) continue;
                        api.deprecated = true;
                    }
                }
                for (APIEntity apiEntity : QuickAPIConfig.apiDocument.apiEntityMap.values()) {
                    handler.handleEntity(apiEntity);
                }
            }
            for (APIController apiController : apiControllerList) {
                for (API api : apiController.apiList) {
                    api.url = QuickAPIConfig.prefix + api.url;
                    for (APIParameter apiParameter : api.apiParameters) {
                        apiParameter.entityType = QuickAPIUtil.getEntityClassName(apiParameter.type);
                        if (!apiParameter.requestType.equals("text") || QuickAPIUtil.needIgnoreClass(apiParameter.entityType)) continue;
                        api.parameterEntityNameList.addAll(QuickAPIUtil.getRecycleEntity(apiParameter.entityType));
                    }
                }
            }
            QuickAPIConfig.apiDocument.apiControllerList = apiControllerList;
            QuickAPIUtil.updateJavaDoc(classNameSet);
            for (APIController apiController : apiControllerList) {
                for (API api : apiController.apiList) {
                    Iterator<APIParameter> iterator = api.apiParameters.iterator();
                    ArrayList<APIParameter> extraAPIParamterList = new ArrayList<APIParameter>();
                    while (iterator.hasNext()) {
                        APIParameter apiParameter = iterator.next();
                        if (!apiParameter.requestType.equals("text") || apiParameter.parameter.getType().isPrimitive() || QuickAPIUtil.needIgnoreClass(apiParameter.entityType)) continue;
                        iterator.remove();
                        APIEntity apiEntity = QuickAPIConfig.apiDocument.apiEntityMap.get(apiParameter.entityType);
                        for (APIField apiField : apiEntity.apiFields) {
                            apiParameter = new APIParameter();
                            apiParameter.setName(apiField.name);
                            apiParameter.type = apiField.className;
                            apiParameter.entityType = QuickAPIUtil.getEntityClassName(apiParameter.type);
                            apiParameter.required = apiField.required;
                            if (apiParameter.type.startsWith("[L") || apiParameter.type.contains("<")) {
                                apiParameter.requestType = "textarea";
                                apiParameter.setDescription(apiField.getDescription() + "(\u591a\u4e2a\u53c2\u6570\u8bf7\u4f7f\u7528\u82f1\u6587\u9017\u53f7\u5206\u9694)");
                            } else {
                                apiParameter.setDescription(apiField.getDescription());
                            }
                            extraAPIParamterList.add(apiParameter);
                        }
                    }
                    api.apiParameters.addAll(extraAPIParamterList);
                }
            }
            File file = new File(QuickAPIConfig.directory + QuickAPIConfig.url + "/api.js");
            this.compareJSON(file);
            String data = "let apiDocument = " + JSON.toJSONString((Object)QuickAPIConfig.apiDocument, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}) + ";";
            this.generateFile(data, file);
            QuickAPIConfig.apiJs = data;
            logger.info("[\u6587\u6863\u8def\u5f84]{}", (Object)file.getAbsolutePath());
            String data2 = this.generateSwagger();
            File file2 = new File(QuickAPIConfig.directory + QuickAPIConfig.url + "/swagger.json");
            this.generateFile(data2, file2);
            URL url = URLClassLoader.getSystemResource("quickapi");
            switch (url.getProtocol()) {
                case "file": {
                    final Path target = Paths.get(QuickAPIConfig.directory + QuickAPIConfig.url, new String[0]);
                    if (!Files.exists(target, new LinkOption[0])) {
                        Files.createDirectory(target, new FileAttribute[0]);
                    }
                    final Path source = Paths.get(url.toURI());
                    final int sourceNameCount = source.getNameCount();
                    Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            if (dir.compareTo(source) != 0) {
                                Path subPath = target.resolve(dir.subpath(sourceNameCount, dir.getNameCount()));
                                Files.createDirectories(subPath, new FileAttribute[0]);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (file.toFile().getName().endsWith("api.js")) {
                                return FileVisitResult.CONTINUE;
                            }
                            Files.copy(file, target.resolve(file.subpath(sourceNameCount, file.getNameCount())), StandardCopyOption.REPLACE_EXISTING);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                    break;
                }
                case "jar": {
                    JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                    JarFile jarFile = jarURLConnection.getJarFile();
                    Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
                    while (jarEntryEnumeration.hasMoreElements()) {
                        JarEntry jarEntry = jarEntryEnumeration.nextElement();
                        if (!jarEntry.getName().endsWith(".html") && !jarEntry.getName().endsWith(".css") && !jarEntry.getName().endsWith(".js") && !jarEntry.getName().endsWith(".woff2") || jarEntry.getName().endsWith("api.js")) continue;
                        InputStream inputStream = jarFile.getInputStream(jarEntry);
                        String name = jarEntry.getName();
                        name = name.substring(name.indexOf("/"));
                        File file3 = new File(QuickAPIConfig.directory + QuickAPIConfig.url + name);
                        this.generateFile(inputStream, file3);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public void upload() {
        this.upload("https://api.schoolwow.cn");
    }

    public void upload(String host) {
        this.upload(host, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String host, Proxy proxy) {
        if (QuickAPIConfig.apiJs == null || QuickAPIConfig.apiJs.isEmpty()) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8c03\u7528generate()\u65b9\u6cd5!");
        }
        StringBuilder sb = new StringBuilder();
        Scanner scanner = null;
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = null == proxy ? (HttpURLConnection)new URL(host + "/api/projectVersion/uploadAPI").openConnection() : (HttpURLConnection)new URL(host + "/api/projectVersion/uploadAPI").openConnection(proxy);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            byte[] bytes = QuickAPIConfig.apiJs.getBytes();
            httpURLConnection.setFixedLengthStreamingMode(bytes.length);
            httpURLConnection.getOutputStream().write(bytes);
            httpURLConnection.getOutputStream().flush();
            httpURLConnection.connect();
            int statusCode = httpURLConnection.getResponseCode();
            scanner = statusCode == 200 ? new Scanner(httpURLConnection.getInputStream()) : new Scanner(httpURLConnection.getErrorStream());
            while (scanner.hasNextLine()) {
                sb.append(scanner.nextLine());
            }
            scanner.close();
            if (statusCode == 200) {
                logger.info("[\u4e0a\u4f20\u6210\u529f]{}", (Object)sb.toString());
            } else {
                logger.warn("[\u4e0a\u4f20\u5931\u8d25]{}", (Object)sb.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
    }

    private void compareJSON(File file) throws FileNotFoundException {
        if (!file.exists()) {
            return;
        }
        Scanner scanner = new Scanner(file);
        StringBuilder builder = new StringBuilder();
        while (scanner.hasNextLine()) {
            builder.append(scanner.nextLine());
        }
        scanner.close();
        if (builder.length() == 0 || builder.indexOf("{") < 0) {
            return;
        }
        String json = builder.substring(builder.indexOf("{"), builder.lastIndexOf("}") + 1);
        APIDocument oldAPIDocument = (APIDocument)JSON.parseObject((String)json).toJavaObject(APIDocument.class);
        List<APIController> oldAPIControllerList = oldAPIDocument.apiControllerList;
        List<APIController> newAPIControllerList = QuickAPIConfig.apiDocument.apiControllerList;
        APIHistory apiHistory = new APIHistory();
        block1: for (APIController newAPIController : newAPIControllerList) {
            if (!oldAPIControllerList.contains(newAPIController)) {
                List<API> newAPIList = newAPIController.apiList;
                Iterator iterator = newAPIList.iterator();
                while (iterator.hasNext()) {
                    API api = (API)iterator.next();
                    apiHistory.addList.add(newAPIController.className + "#" + api.methods[0] + "_" + api.url);
                    logger.info("[\u65b0\u589e\u63a5\u53e3]{} {} {}", new Object[]{api.getName(), api.methods[0], api.url});
                }
                continue;
            }
            for (APIController aPIController : oldAPIControllerList) {
                if (!newAPIController.className.equals(aPIController.className)) continue;
                List<API> newAPIList = newAPIController.apiList;
                List<API> oldAPIList = aPIController.apiList;
                block4: for (API newAPI : newAPIList) {
                    if (!oldAPIList.contains(newAPI)) {
                        apiHistory.addList.add(newAPIController.className + "#" + newAPI.methods[0] + "_" + newAPI.url);
                        logger.info("[\u65b0\u589e\u63a5\u53e3]{} {} {}", new Object[]{newAPI.getName(), newAPI.methods[0], newAPI.url});
                        continue;
                    }
                    for (API oldAPI : oldAPIList) {
                        if (!newAPI.equals(oldAPI) || newAPI.apiParameters.equals(oldAPI.apiParameters)) continue;
                        apiHistory.modifyList.add(newAPIController.className + "#" + newAPI.methods[0] + "_" + newAPI.url);
                        logger.info("[\u53d8\u66f4\u63a5\u53e3]{} {} {}", new Object[]{newAPI.getName(), newAPI.methods[0], newAPI.url});
                        continue block4;
                    }
                }
                continue block1;
            }
        }
        block6: for (APIController oldAPIController : oldAPIControllerList) {
            if (!newAPIControllerList.contains(oldAPIController)) {
                List<API> apiList = oldAPIController.apiList;
                for (API api : apiList) {
                    apiHistory.deleteList.add(api);
                    logger.info("[\u5220\u9664\u63a5\u53e3]{} {} {}", new Object[]{api.getName(), api.methods[0], api.url});
                }
                continue;
            }
            for (APIController aPIController : newAPIControllerList) {
                if (!oldAPIController.className.equals(aPIController.className)) continue;
                List<API> oldAPIList = oldAPIController.apiList;
                List<API> newAPIList = aPIController.apiList;
                for (API oldAPI : oldAPIList) {
                    if (newAPIList.contains(oldAPI)) continue;
                    apiHistory.deleteList.add(oldAPI);
                    logger.info("[\u5220\u9664\u63a5\u53e3]{} {} {}", new Object[]{oldAPI.getName(), oldAPI.methods[0], oldAPI.url});
                }
                continue block6;
            }
        }
        if (!(apiHistory.addList.isEmpty() && apiHistory.modifyList.isEmpty() && apiHistory.deleteList.isEmpty())) {
            oldAPIDocument.apiHistoryList.add(0, apiHistory);
        }
        QuickAPIConfig.apiDocument.apiHistoryList = oldAPIDocument.apiHistoryList;
    }

    private String generateSwagger() {
        JSONObject o = new JSONObject();
        o.put("swagger", (Object)"2.0");
        o.put("info", (Object)JSON.parseObject((String)("{\"title\":\"" + QuickAPIConfig.apiDocument.title + "\",\"version\":\"last\"}")));
        o.put("basePath", (Object)"/");
        JSONArray tagArray = new JSONArray();
        for (APIController apiController : QuickAPIConfig.apiDocument.apiControllerList) {
            tagArray.add((Object)JSON.parseObject((String)("{\"name\":\"" + apiController.getName() + "\",\"description\":null}")));
        }
        o.put("tags", (Object)tagArray);
        o.put("schemes", (Object)JSON.parseArray((String)"[\"http\"]"));
        JSONObject paths = new JSONObject();
        for (APIController apiController : QuickAPIConfig.apiDocument.apiControllerList) {
            for (API api : apiController.apiList) {
                JSONObject p = new JSONObject();
                p.put("tags", (Object)JSON.parseArray((String)("[\"" + apiController.getName() + "\"]")));
                p.put("summary", (Object)api.getName());
                p.put("description", (Object)api.getDescription());
                JSONArray parameters = new JSONArray();
                for (APIParameter apiParameter : api.apiParameters) {
                    JSONObject q = new JSONObject();
                    q.put("name", (Object)apiParameter.getName());
                    q.put("in", (Object)apiParameter.position);
                    q.put("required", (Object)apiParameter.required);
                    if (null == apiParameter.getDescription()) {
                        q.put("description", (Object)"");
                    } else {
                        q.put("description", (Object)(apiParameter.getDescription() + ("".equals(apiParameter.defaultValue) ? "" : ",\u9ed8\u8ba4\u4e3a" + apiParameter.defaultValue)));
                    }
                    switch (apiParameter.requestType) {
                        case "text": {
                            q.put("type", (Object)"string");
                            break;
                        }
                        case "textarea": {
                            q.put("name", (Object)"root");
                            p.put("consumes", (Object)JSON.parseArray((String)"[\"application/json\"]"));
                            JSONObject schema = new JSONObject();
                            schema.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
                            schema.put("type", (Object)"object");
                            APIEntity apiEntity = QuickAPIConfig.apiDocument.apiEntityMap.get(apiParameter.type);
                            if (null != apiEntity) {
                                JSONObject fieldProperty = new JSONObject();
                                if (null != apiEntity.apiFields) {
                                    for (APIField apiField : apiEntity.apiFields) {
                                        fieldProperty.put(apiField.name, (Object)JSON.parseObject((String)("{\"type\":\"string\",\"description\":\"" + apiField.getDescription() + "\"}")));
                                    }
                                }
                                schema.put("properties", (Object)fieldProperty);
                            }
                            q.put("schema", (Object)schema);
                            break;
                        }
                        case "file": {
                            q.put("in", (Object)"formData");
                            q.put("type", (Object)"file");
                            q.put("description", (Object)"\u4e0a\u4f20\u7684\u6587\u4ef6");
                            p.put("consumes", (Object)JSON.parseArray((String)"[\"multipart/form-data\"]"));
                        }
                    }
                    parameters.add((Object)q);
                }
                p.put("parameters", (Object)parameters);
                p.put("responses", (Object)JSON.parseObject((String)"{\"200\":{\"description\":\"successful operation\",\"schema\":{}}}"));
                paths.put(api.url, (Object)JSON.parseObject((String)("{\"" + api.methods[0].toLowerCase() + "\":" + p.toJSONString() + "}")));
            }
        }
        o.put("paths", (Object)paths);
        return o.toJSONString();
    }

    private void generateFile(InputStream inputStream, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
        byte[] bytes = new byte[8192];
        int length = -1;
        while ((length = inputStream.read(bytes, 0, bytes.length)) != -1) {
            fos.write(bytes, 0, length);
        }
        fos.flush();
        fos.close();
    }

    private void generateFile(String data, File file) throws FileNotFoundException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        PrintWriter pw = new PrintWriter(file);
        pw.print(data);
        pw.flush();
        pw.close();
    }

    static {
        Set<String> classNameSet = QuickAPIUtil.scanPackage("cn.schoolwow.quickapi.handler");
        ArrayList<Handler> handlerList = new ArrayList<Handler>();
        for (String className : classNameSet) {
            if (className.equals("cn.schoolwow.quickapi.handler.AbstractHandler") || className.equals("cn.schoolwow.quickapi.handler.Handler")) continue;
            try {
                handlerList.add((Handler)ClassLoader.getSystemClassLoader().loadClass(className).newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        handlers = handlerList.toArray(new Handler[0]);
    }
}

