/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.util.QuickAPIConfig;
import cn.schoolwow.quickbeans.annotation.Component;
import cn.schoolwow.quickserver.annotation.PathVariable;
import cn.schoolwow.quickserver.annotation.RequestBody;
import cn.schoolwow.quickserver.annotation.RequestMapping;
import cn.schoolwow.quickserver.annotation.RequestMethod;
import cn.schoolwow.quickserver.annotation.RequestParam;
import cn.schoolwow.quickserver.annotation.RequestPart;
import cn.schoolwow.quickserver.request.MultipartFile;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class QuickServerHandler
extends AbstractHandler {
    @Override
    public boolean exist() {
        try {
            QuickAPIConfig.urlClassLoader.loadClass("cn.schoolwow.quickserver.annotation.RequestMapping");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isControllerEnvironment() {
        return true;
    }

    @Override
    public APIController getApiController(Class clazz) {
        if (null == clazz.getAnnotation(Component.class)) {
            return null;
        }
        ArrayList<API> apiList = new ArrayList<API>();
        for (Method method : clazz.getDeclaredMethods()) {
            API api = this.handleRequestMapping(method);
            if (null == api) continue;
            api.method = method;
            apiList.add(api);
        }
        if (apiList.isEmpty()) {
            return null;
        }
        APIController apiController = new APIController();
        apiController.clazz = clazz;
        apiController.className = clazz.getName();
        apiController.setName(clazz.getSimpleName());
        apiController.apiList = apiList;
        RequestMapping classRequestMapping = clazz.getDeclaredAnnotation(RequestMapping.class);
        if (classRequestMapping != null) {
            String baseUrl = classRequestMapping.value();
            if (baseUrl.charAt(0) != '/') {
                baseUrl = "/" + baseUrl;
            }
            for (API api : apiController.apiList) {
                api.url = baseUrl + api.url;
            }
        }
        for (API api : apiController.apiList) {
            this.handleAPIParameter(api);
            this.handleReturnValue(api);
        }
        return apiController;
    }

    @Override
    public void handleController(APIController apiController) {
    }

    @Override
    public void handleAPI(API api) {
    }

    @Override
    public void handleEntity(APIEntity apiEntity) {
    }

    private void handleAPIParameter(API api) {
        Parameter[] parameters = api.method.getParameters();
        ArrayList<APIParameter> apiParameterList = new ArrayList<APIParameter>();
        ArrayList<String> parameterEntityNameList = new ArrayList<String>();
        for (Parameter parameter : parameters) {
            PathVariable pathVariable;
            RequestBody requestBody;
            RequestPart requestPart;
            Class<?> parameterType = parameter.getType();
            if (!parameterType.getName().equals(MultipartFile.class.getName()) && parameterType.getName().startsWith("cn.schoolwow.quickserver")) continue;
            Type type = parameter.getParameterizedType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type genericType = pType.getActualTypeArguments()[0];
                parameterEntityNameList.add(genericType.getTypeName());
            }
            APIParameter apiParameter = new APIParameter();
            apiParameter.parameter = parameter;
            RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
            if (requestParam != null) {
                apiParameter.setName(requestParam.name());
                apiParameter.required = requestParam.required();
                apiParameter.defaultValue = requestParam.defaultValue();
                boolean existBodyMethod = false;
                for (String requestMethod : api.methods) {
                    if (!"POST".equalsIgnoreCase(requestMethod) && !"PUT".equalsIgnoreCase(requestMethod) && !"PATCH".equalsIgnoreCase(requestMethod)) continue;
                    existBodyMethod = true;
                    break;
                }
                apiParameter.position = existBodyMethod ? "body" : "query";
            }
            if ((requestPart = parameter.getAnnotation(RequestPart.class)) != null || parameterType.getName().equals(MultipartFile.class.getName())) {
                apiParameter.setName(requestPart.name());
                apiParameter.required = requestPart.required();
                apiParameter.requestType = "file";
                api.contentType = "multipart/form-data;";
            }
            if ((requestBody = parameter.getAnnotation(RequestBody.class)) != null) {
                apiParameter.setName("requestBody");
                apiParameter.required = requestBody.required();
                apiParameter.requestType = "textarea";
                api.contentType = "application/json; charset=utf-8";
            }
            if ((pathVariable = parameter.getAnnotation(PathVariable.class)) != null) {
                apiParameter.setName(pathVariable.name());
                apiParameter.required = pathVariable.required();
                apiParameter.position = "path";
            }
            if (parameterType.getName().equals(MultipartFile.class.getName())) {
                apiParameter.setName(parameter.getName());
                apiParameter.requestType = "file";
                api.contentType = "multipart/form-data;";
            }
            if (null == apiParameter.getName() || apiParameter.getName().isEmpty()) continue;
            apiParameter.type = parameter.getType().getName();
            apiParameterList.add(apiParameter);
        }
        api.apiParameters = apiParameterList;
    }

    private API handleRequestMapping(Method method) {
        RequestMapping methodRequestMapping = method.getDeclaredAnnotation(RequestMapping.class);
        if (methodRequestMapping == null) {
            return null;
        }
        RequestMethod[] requestMethods = methodRequestMapping.method();
        API api = new API();
        if (requestMethods.length > 0) {
            api.methods = new String[requestMethods.length];
            for (int i = 0; i < requestMethods.length; ++i) {
                api.methods[i] = requestMethods[i].name().toUpperCase();
            }
        } else {
            api.methods = new String[]{"all"};
        }
        api.url = methodRequestMapping.value();
        return api;
    }
}

