/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.util.QuickAPIConfig;
import cn.schoolwow.quickapi.util.QuickAPIUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttribute;
import org.springframework.web.multipart.MultipartFile;

public class SpringMVCHandler
extends AbstractHandler {
    @Override
    public boolean exist() {
        try {
            QuickAPIConfig.urlClassLoader.loadClass("org.springframework.web.bind.annotation.RequestMapping");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isControllerEnvironment() {
        return true;
    }

    @Override
    public APIController getApiController(Class clazz) {
        if (null == clazz.getAnnotation(Component.class) && null == clazz.getAnnotation(Controller.class) && null == clazz.getAnnotation(RestController.class)) {
            return null;
        }
        ArrayList<API> apiList = new ArrayList<API>();
        for (Method method : clazz.getDeclaredMethods()) {
            API api = this.handleMethodMappingClass(method);
            if (null == api) {
                api = this.handleRequestMapping(method);
            }
            if (null == api) continue;
            api.method = method;
            apiList.add(api);
        }
        if (apiList.isEmpty()) {
            return null;
        }
        APIController apiController = new APIController();
        apiController.clazz = clazz;
        apiController.className = clazz.getName();
        apiController.setName(clazz.getSimpleName());
        apiController.apiList = apiList;
        RequestMapping classRequestMapping = clazz.getDeclaredAnnotation(RequestMapping.class);
        if (classRequestMapping != null) {
            String baseUrl = "";
            baseUrl = classRequestMapping.value().length > 0 ? classRequestMapping.value()[0] : clazz.getSimpleName().toLowerCase();
            if (baseUrl.charAt(0) != '/') {
                baseUrl = "/" + baseUrl;
            }
            for (API api : apiController.apiList) {
                api.url = baseUrl + api.url;
            }
        }
        for (API api : apiController.apiList) {
            this.handleAPIParameter(api);
            this.handleReturnValue(api);
        }
        return apiController;
    }

    @Override
    public void handleController(APIController apiController) {
    }

    @Override
    public void handleAPI(API api) {
    }

    @Override
    public void handleEntity(APIEntity apiEntity) {
    }

    private void handleAPIParameter(API api) {
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] parameterNames = u.getParameterNames(api.method);
        Parameter[] parameters = api.method.getParameters();
        ArrayList<APIParameter> apiParameterList = new ArrayList<APIParameter>();
        ArrayList<String> parameterEntityNameList = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            PathVariable pathVariable;
            RequestBody requestBody;
            RequestPart requestPart;
            Class<?> parameterType = parameters[i].getType();
            if (!parameterType.getName().equals(MultipartFile.class.getName()) && (parameterType.getName().startsWith("javax.servlet") || parameterType.getName().startsWith("org.springframework")) || null != parameters[i].getAnnotation(SessionAttribute.class)) continue;
            Type type = parameters[i].getParameterizedType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type genericType = pType.getActualTypeArguments()[0];
                parameterEntityNameList.addAll(QuickAPIUtil.getRecycleEntity(genericType.getTypeName()));
            }
            APIParameter apiParameter = new APIParameter();
            apiParameter.parameter = parameters[i];
            RequestParam requestParam = parameters[i].getAnnotation(RequestParam.class);
            if (requestParam != null) {
                apiParameter.setName(requestParam.value());
                apiParameter.setName(requestParam.name());
                apiParameter.required = requestParam.required();
                if (!requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                    apiParameter.defaultValue = requestParam.defaultValue();
                }
                boolean existBodyMethod = false;
                for (String requestMethod : api.methods) {
                    if (!"POST".equalsIgnoreCase(requestMethod) && !"PUT".equalsIgnoreCase(requestMethod) && !"PATCH".equalsIgnoreCase(requestMethod)) continue;
                    existBodyMethod = true;
                    break;
                }
                apiParameter.position = existBodyMethod ? "body" : "query";
            }
            if ((requestPart = parameters[i].getAnnotation(RequestPart.class)) != null) {
                if (null != requestPart) {
                    apiParameter.setName(requestPart.value());
                    apiParameter.setName(requestPart.name());
                    apiParameter.required = requestPart.required();
                } else {
                    apiParameter.setName(parameterNames[i]);
                    apiParameter.required = true;
                }
                apiParameter.requestType = "file";
                api.contentType = "multipart/form-data;";
            }
            if ((requestBody = parameters[i].getAnnotation(RequestBody.class)) != null) {
                apiParameter.setName("requestBody");
                apiParameter.required = requestBody.required();
                apiParameter.requestType = "textarea";
                api.contentType = "application/json; charset=utf-8";
                parameterEntityNameList.addAll(QuickAPIUtil.getRecycleEntity(parameterType.getName()));
            }
            if ((pathVariable = parameters[i].getAnnotation(PathVariable.class)) != null) {
                apiParameter.setName(pathVariable.value());
                apiParameter.setName(pathVariable.name());
                apiParameter.required = pathVariable.required();
                apiParameter.position = "query";
            }
            if (parameterType.getName().equals(MultipartFile.class.getName())) {
                apiParameter.requestType = "file";
                api.contentType = "multipart/form-data;";
            }
            if (null == apiParameter.getName() || apiParameter.getName().isEmpty()) {
                apiParameter.setName(parameterNames[i]);
            }
            apiParameter.type = parameters[i].getType().getName();
            apiParameterList.add(apiParameter);
        }
        api.parameterEntityNameList = parameterEntityNameList;
        api.apiParameters = apiParameterList;
    }

    private API handleMethodMappingClass(Method method) {
        Class[] mappingClasses;
        for (Class mappingClass : mappingClasses = new Class[]{GetMapping.class, PostMapping.class, PutMapping.class, DeleteMapping.class, PatchMapping.class}) {
            API api;
            block3: {
                Object annotation = method.getDeclaredAnnotation(mappingClass);
                if (annotation == null) continue;
                String requestMethod = mappingClass.getSimpleName().substring(0, mappingClass.getSimpleName().lastIndexOf("Mapping")).toUpperCase();
                api = new API();
                api.methods = new String[]{requestMethod};
                try {
                    String[] values = (String[])mappingClass.getDeclaredMethod("value", new Class[0]).invoke(annotation, new Object[0]);
                    api.url = values[0];
                    if (api.url.charAt(0) == '/') break block3;
                    api.url = "/" + api.url;
                }
                catch (Exception e) {
                    continue;
                }
            }
            return api;
        }
        return null;
    }

    private API handleRequestMapping(Method method) {
        RequestMapping methodRequestMapping = method.getDeclaredAnnotation(RequestMapping.class);
        if (null == methodRequestMapping) {
            return null;
        }
        API api = new API();
        RequestMethod[] requestMethods = methodRequestMapping.method();
        if (requestMethods.length > 0) {
            api.methods = new String[requestMethods.length];
            for (int i = 0; i < requestMethods.length; ++i) {
                api.methods[i] = requestMethods[i].name().toUpperCase();
            }
        } else {
            api.methods = new String[]{"all"};
        }
        api.url = methodRequestMapping.value().length > 0 ? methodRequestMapping.value()[0] : method.getName();
        if (api.url.charAt(0) != '/') {
            api.url = "/" + api.url;
        }
        return api;
    }
}

