/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIField;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.util.QuickAPIConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

public class SwaggerHandler
extends AbstractHandler {
    @Override
    public boolean exist() {
        try {
            QuickAPIConfig.urlClassLoader.loadClass("io.swagger.annotations.ApiModel");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean isControllerEnvironment() {
        return false;
    }

    @Override
    public APIController getApiController(Class clazz) {
        return null;
    }

    @Override
    public void handleController(APIController apiController) {
        Api api = (Api)apiController.clazz.getAnnotation(API.class);
        if (null != api) {
            apiController.setName(api.tags()[0]);
        }
        for (API api2 : apiController.apiList) {
            ApiOperation apiOperation = api2.method.getAnnotation(ApiOperation.class);
            if (null != apiOperation) {
                api2.setName(apiOperation.value());
                api2.setDescription(apiOperation.notes());
            }
            for (APIParameter apiParameter : api2.apiParameters) {
                ApiParam apiParam = apiParameter.parameter.getAnnotation(ApiParam.class);
                if (null == apiParam) continue;
                apiParameter.setName(apiParam.name());
                apiParameter.setDescription(apiParam.value());
                apiParameter.required = apiParam.required();
                apiParameter.defaultValue = apiParam.defaultValue();
            }
        }
    }

    @Override
    public void handleAPI(API api) {
    }

    @Override
    public void handleEntity(APIEntity apiEntity) {
        ApiModel apiModel = apiEntity.clazz.getAnnotation(ApiModel.class);
        if (null != apiModel) {
            apiEntity.setDescription(apiModel.description());
            apiEntity.setDescription(apiModel.value());
        }
        for (APIField apiField : apiEntity.apiFields) {
            ApiModelProperty apiModelProperty = apiField.field.getAnnotation(ApiModelProperty.class);
            if (null == apiModelProperty) continue;
            apiField.setDescription(apiModelProperty.value());
            apiField.required = apiModelProperty.required();
            apiField.example = apiModelProperty.example();
        }
    }
}

