/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.util;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.APIException;
import cn.schoolwow.quickapi.domain.APIField;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.util.JavaDocReader;
import cn.schoolwow.quickapi.util.QuickAPIConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickAPIUtil {
    private static Logger logger = LoggerFactory.getLogger(QuickAPIUtil.class);

    public static void initClassPath() {
        URL[] urls;
        QuickAPIConfig.classPathList.addAll(Arrays.asList(((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs()));
        StringBuilder builder = new StringBuilder();
        QuickAPIConfig.urlClassLoader = new URLClassLoader(QuickAPIConfig.classPathList.toArray(new URL[0]));
        for (URL url : urls = QuickAPIConfig.urlClassLoader.getURLs()) {
            builder.append(url.getPath().substring(1) + ";");
        }
        JavaDocReader.classPath = builder.toString();
    }

    public static Set<String> scanPackage(String ... packageNames) {
        final HashSet<String> classNameSet = new HashSet<String>();
        for (String packageName : packageNames) {
            String packageNamePath = packageName.replace(".", "/");
            try {
                Enumeration<URL> urlEnumeration = QuickAPIConfig.urlClassLoader.getResources(packageNamePath);
                while (urlEnumeration.hasMoreElements()) {
                    URL url = urlEnumeration.nextElement();
                    if (url == null) continue;
                    logger.info("[\u7c7b\u6587\u4ef6\u8def\u5f84]\u5305\u8def\u5f84:{},URL:{}", (Object)packageNamePath, (Object)url.toString());
                    switch (url.getProtocol()) {
                        case "file": {
                            File file = new File(url.getFile());
                            if (!file.isDirectory()) {
                                throw new IllegalArgumentException("\u5305\u540d\u4e0d\u662f\u5408\u6cd5\u7684\u6587\u4ef6\u5939!" + url.getFile());
                            }
                            final String indexOfString = packageName.replace(".", "/");
                            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                    int startIndex;
                                    String path;
                                    String className;
                                    File f = file.toFile();
                                    if (f.getName().endsWith(".class") && !QuickAPIUtil.shouldFilterClass(className = (path = f.getAbsolutePath().replace("\\", "/")).substring(startIndex = path.indexOf(indexOfString), path.length() - 6).replace("/", "."))) {
                                        classNameSet.add(className);
                                    }
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                            break;
                        }
                        case "jar": {
                            JarFile jarFile;
                            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                            if (null == jarURLConnection || null == (jarFile = jarURLConnection.getJarFile())) break;
                            Enumeration<JarEntry> jarEntries = jarFile.entries();
                            while (jarEntries.hasMoreElements()) {
                                String className;
                                JarEntry jarEntry = jarEntries.nextElement();
                                String jarEntryName = jarEntry.getName();
                                if (!jarEntryName.contains(packageNamePath) || !jarEntryName.endsWith(".class") || QuickAPIUtil.shouldFilterClass(className = jarEntryName.substring(0, jarEntryName.lastIndexOf(".")).replaceAll("/", "."))) continue;
                                classNameSet.add(className);
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        classNameSet.addAll(QuickAPIConfig.controllerClassNameList);
        return classNameSet;
    }

    public static Set<String> scanControllerPackage() {
        return QuickAPIUtil.scanPackage(QuickAPIConfig.controllerPackageNameList.toArray(new String[0]));
    }

    public static boolean needIgnoreClass(String className) {
        if (className.startsWith("byte") || className.startsWith("boolean") || className.startsWith("char") || className.startsWith("short") || className.startsWith("int") || className.startsWith("long") || className.startsWith("float") || className.startsWith("double") || className.equals("T") || className.equals("E") || className.equals("?")) {
            return true;
        }
        for (String ignorePackageName : QuickAPIConfig.ignorePackageNameList) {
            if (!className.startsWith(ignorePackageName)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getRecycleEntity(String className) {
        Stack<String> apiEntityStack = new Stack<String>();
        while (className.contains("<")) {
            apiEntityStack.add(className.substring(0, className.indexOf("<")));
            className = className.substring(className.indexOf("<") + 1, className.lastIndexOf(">"));
        }
        apiEntityStack.add(className);
        LinkedHashSet<String> apiEntitySet = new LinkedHashSet<String>();
        while (!apiEntityStack.isEmpty()) {
            className = (String)apiEntityStack.pop();
            if (className.startsWith("[")) {
                className = className.substring(2, className.length() - 1);
            }
            if (QuickAPIUtil.needIgnoreClass(className)) continue;
            Class<?> clazz = null;
            try {
                clazz = QuickAPIConfig.urlClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                logger.warn("[\u52a0\u8f7d\u7c7b\u4e0d\u5b58\u5728]\u7c7b\u540d:{}", (Object)className);
                continue;
            }
            apiEntitySet.add(clazz.getName());
            Map<String, APIEntity> apiEntityMap = QuickAPIConfig.apiDocument.apiEntityMap;
            if (apiEntityMap.containsKey(clazz.getName())) continue;
            APIEntity apiEntity = QuickAPIUtil.addAPIEntity(clazz);
            apiEntityMap.put(clazz.getName(), apiEntity);
            for (APIField apiField : apiEntity.apiFields) {
                className = QuickAPIUtil.getEntityClassName(apiField.className);
                if (QuickAPIUtil.needIgnoreClass(className) || apiEntityMap.containsKey(className)) continue;
                apiEntityStack.push(className);
            }
        }
        return apiEntitySet;
    }

    public static String getEntityClassName(String className) {
        if (className.startsWith("[")) {
            switch (className) {
                case "[Z": {
                    className = "boolean";
                    break;
                }
                case "[C": {
                    className = "char";
                    break;
                }
                case "[S": {
                    className = "short";
                    break;
                }
                case "[I": {
                    className = "int";
                    break;
                }
                case "[J": {
                    className = "long";
                    break;
                }
                case "[F": {
                    className = "float";
                    break;
                }
                case "[D": {
                    className = "double";
                    break;
                }
                default: {
                    if (className.startsWith("[L")) {
                        className = className.substring(2, className.length() - 1);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (className.contains("<") && className.contains(">")) {
            className = className.substring(className.indexOf("<") + 1, className.indexOf(">"));
        }
        return className;
    }

    public static APIEntity addAPIEntity(Class clazz) {
        APIEntity apiEntity = new APIEntity();
        apiEntity.clazz = clazz;
        apiEntity.className = clazz.getName();
        apiEntity.simpleName = clazz.getSimpleName();
        AccessibleObject[] fields = QuickAPIUtil.getAllField(clazz);
        APIField[] apiFields = new APIField[fields.length];
        Field.setAccessible(fields, true);
        for (int i = 0; i < fields.length; ++i) {
            APIField apiField = new APIField();
            apiField.field = fields[i];
            apiField.name = ((Field)fields[i]).getName();
            apiField.className = ((Field)fields[i]).getType().getName();
            Type type = ((Field)fields[i]).getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type genericType = pType.getActualTypeArguments()[0];
                apiField.className = apiField.className + "<" + genericType.getTypeName() + ">";
            }
            apiFields[i] = apiField;
        }
        apiEntity.apiFields = apiFields;
        try {
            apiEntity.instance = JSON.toJSONString(clazz.newInstance(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        }
        catch (Exception e) {
            logger.warn("[\u5b9e\u4f8b\u5316\u5931\u8d25]\u539f\u56e0:{},\u7c7b\u540d:{}", (Object)e.getMessage(), (Object)clazz.getName());
        }
        return apiEntity;
    }

    public static void updateJavaDoc(Set<String> classNameSet) {
        ClassDoc[] classDocs = JavaDocReader.getJavaDoc(classNameSet);
        for (APIController apiController : QuickAPIConfig.apiDocument.apiControllerList) {
            for (ClassDoc classDoc : classDocs) {
                if (!apiController.className.equals(classDoc.qualifiedName())) continue;
                apiController.setName(classDoc.commentText().trim());
                MethodDoc[] methodDocs = classDoc.methods();
                block2: for (API api : apiController.apiList) {
                    MethodDoc[] methodDocArray = methodDocs;
                    int n = methodDocArray.length;
                    for (int i = 0; i < n; ++i) {
                        Tag[] sinceTags;
                        MethodDoc methodDoc = methodDocArray[i];
                        if (!api.method.getName().equals(methodDoc.name()) || api.method.getParameterCount() != methodDoc.parameters().length) continue;
                        Tag[] apiNotes = methodDoc.tags("apiNote");
                        if (null != apiNotes && apiNotes.length > 0) {
                            api.setName(apiNotes[0].inlineTags()[0].text());
                        }
                        api.setName(methodDoc.commentText().trim());
                        api.setName(methodDoc.name());
                        api.setDescription(methodDoc.commentText().trim());
                        Tag[] authorTags = methodDoc.tags("author");
                        if (null != authorTags && authorTags.length > 0) {
                            api.author = authorTags[0].text();
                        }
                        if (null != (sinceTags = methodDoc.tags("since")) && sinceTags.length > 0) {
                            api.since = sinceTags[0].text();
                        }
                        ParamTag[] paramTags = methodDoc.paramTags();
                        block4: for (APIParameter apiParameter : api.apiParameters) {
                            for (ParamTag paramTag : paramTags) {
                                if (null == apiParameter.parameter || !apiParameter.getName().equals(paramTag.parameterName())) continue;
                                apiParameter.setName(paramTag.parameterName());
                                apiParameter.setDescription(paramTag.parameterComment());
                                continue block4;
                            }
                        }
                        ThrowsTag[] throwsTags = methodDoc.throwsTags();
                        if (null == throwsTags || throwsTags.length <= 0) continue block2;
                        api.apiExceptions = new APIException[throwsTags.length];
                        for (int i2 = 0; i2 < throwsTags.length; ++i2) {
                            APIException apiException = new APIException();
                            apiException.className = throwsTags[i2].exceptionName();
                            apiException.description = throwsTags[i2].exceptionComment();
                            api.apiExceptions[i2] = apiException;
                        }
                        continue block2;
                    }
                }
            }
        }
        classDocs = JavaDocReader.getJavaDoc(QuickAPIConfig.apiDocument.apiEntityMap.keySet());
        block7: for (APIEntity apiEntity : QuickAPIConfig.apiDocument.apiEntityMap.values()) {
            for (ClassDoc classDoc : classDocs) {
                Tag[] sinceTags;
                if (!apiEntity.className.equals(classDoc.qualifiedName())) continue;
                apiEntity.setDescription(classDoc.commentText());
                Tag[] authorTags = classDoc.tags("author");
                if (null != authorTags && authorTags.length > 0) {
                    apiEntity.author = authorTags[0].text();
                }
                if (null != (sinceTags = classDoc.tags("since")) && sinceTags.length > 0) {
                    apiEntity.since = sinceTags[0].text();
                }
                block9: for (APIField apiField : apiEntity.apiFields) {
                    for (FieldDoc fieldDoc : QuickAPIUtil.getAllFieldDoc(classDoc)) {
                        if (!apiField.name.equals(fieldDoc.name())) continue;
                        apiField.setDescription(fieldDoc.getRawCommentText());
                        continue block9;
                    }
                }
                continue block7;
            }
        }
    }

    public static Field[] getAllField(Class clazz) {
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        Class tempClass = clazz;
        while (null != tempClass) {
            AccessibleObject[] fields = tempClass.getDeclaredFields();
            Field.setAccessible(fields, true);
            for (AccessibleObject field : fields) {
                if (Modifier.isFinal(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).setAccessible(true);
                fieldList.add(field);
            }
            if (null == (tempClass = tempClass.getSuperclass()) || !"java.lang.Object".equals(tempClass.getName())) continue;
            break;
        }
        return fieldList.toArray(new Field[0]);
    }

    public static FieldDoc[] getAllFieldDoc(ClassDoc classDoc) {
        ArrayList<FieldDoc> fieldDocList = new ArrayList<FieldDoc>();
        ClassDoc tempClassDoc = classDoc;
        while (null != tempClassDoc) {
            FieldDoc[] fieldDocs;
            for (FieldDoc fieldDoc : fieldDocs = tempClassDoc.fields()) {
                if (Modifier.isFinal(fieldDoc.modifierSpecifier()) || Modifier.isStatic(fieldDoc.modifierSpecifier())) continue;
                fieldDocList.add(fieldDoc);
            }
            if (null == (tempClassDoc = tempClassDoc.superclass()) || !"java.lang.Object".equals(tempClassDoc.qualifiedName())) continue;
            break;
        }
        return fieldDocList.toArray(new FieldDoc[0]);
    }

    private static boolean shouldFilterClass(String className) {
        if (!QuickAPIConfig.ignoreClassList.isEmpty()) {
            for (String ignoreClassName : QuickAPIConfig.ignoreClassList) {
                if (!className.startsWith(ignoreClassName)) continue;
                logger.warn("[\u5ffd\u7565\u7c7b\u540d]\u7c7b\u540d:{}!", (Object)className);
                return true;
            }
        }
        if (!QuickAPIConfig.ignorePackageNameList.isEmpty()) {
            for (String ignorePackageName : QuickAPIConfig.ignorePackageNameList) {
                if (!className.contains(ignorePackageName)) continue;
                logger.warn("[\u5ffd\u7565\u5305\u540d]\u5305\u540d:{}\u7c7b\u540d:{}", (Object)ignorePackageName, (Object)className);
                return true;
            }
        }
        return null != QuickAPIConfig.predicate && QuickAPIConfig.predicate.test(className);
    }
}

