/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIException;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickapi.handler.APIParameterHandler;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.handler.Handler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class APIHandler
extends AbstractHandler {
    public APIHandler(QuickAPIOption option) {
        super(option);
    }

    @Override
    public Handler handle(APIDocument apiDocument) throws Exception {
        for (APIController apiController : apiDocument.apiControllerList) {
            this.getAPI(apiController);
        }
        return new APIParameterHandler(this.option);
    }

    private void getAPI(APIController apiController) {
        String baseUrl = this.getBaseUrl(apiController);
        ArrayList<API> apiList = new ArrayList<API>();
        for (Method method : apiController.clazz.getDeclaredMethods()) {
            API api = this.getMethodMappingAnnotation(method);
            if (null == api) {
                api = this.getRequestMappingAnnotation(method);
            }
            if (null == api) continue;
            api.url = baseUrl + api.url;
            this.getAPI(api, method);
            apiList.add(api);
        }
        apiController.apiList = apiList;
    }

    private void getAPI(API api, Method method) {
        api.methodName = method.getName();
        if (null != method.getAnnotation(Deprecated.class)) {
            api.deprecated = true;
        }
        api.returnClassName = method.getReturnType().getName();
        Type type = method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            api.returnClassName = method.getGenericReturnType().getTypeName();
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        api.apiExceptions = new APIException[exceptionTypes.length];
        for (int i = 0; i < exceptionTypes.length; ++i) {
            APIException apiException = new APIException();
            apiException.className = exceptionTypes[i].getName();
            api.apiExceptions[i] = apiException;
        }
        api.method = method;
    }

    private API getRequestMappingAnnotation(Method method) {
        RequestMapping methodRequestMapping = method.getDeclaredAnnotation(RequestMapping.class);
        if (null == methodRequestMapping) {
            return null;
        }
        API api = new API();
        RequestMethod[] requestMethods = methodRequestMapping.method();
        if (requestMethods.length > 0) {
            api.requestMethod = requestMethods[0].name().toUpperCase();
        }
        api.url = methodRequestMapping.value().length > 0 ? methodRequestMapping.value()[0] : method.getName();
        if (api.url.charAt(0) != '/') {
            api.url = "/" + api.url;
        }
        return api;
    }

    private API getMethodMappingAnnotation(Method method) {
        Class[] mappingClasses;
        for (Class mappingClass : mappingClasses = new Class[]{GetMapping.class, PostMapping.class, PutMapping.class, DeleteMapping.class, PatchMapping.class}) {
            API api;
            block3: {
                Object annotation = method.getDeclaredAnnotation(mappingClass);
                if (annotation == null) continue;
                String requestMethod = mappingClass.getSimpleName().substring(0, mappingClass.getSimpleName().lastIndexOf("Mapping")).toUpperCase();
                api = new API();
                api.requestMethod = requestMethod.toUpperCase();
                try {
                    String[] values = (String[])mappingClass.getDeclaredMethod("value", new Class[0]).invoke(annotation, new Object[0]);
                    api.url = values[0];
                    if (api.url.charAt(0) == '/') break block3;
                    api.url = "/" + api.url;
                }
                catch (Exception e) {
                    continue;
                }
            }
            return api;
        }
        return null;
    }

    private String getBaseUrl(APIController apiController) {
        String baseUrl = "";
        RequestMapping classRequestMapping = apiController.clazz.getDeclaredAnnotation(RequestMapping.class);
        if (null != classRequestMapping && (baseUrl = classRequestMapping.value().length > 0 ? classRequestMapping.value()[0] : apiController.clazz.getSimpleName().toLowerCase()).charAt(0) != '/') {
            baseUrl = "/" + baseUrl;
        }
        return baseUrl;
    }
}

