/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.handler;

import cn.schoolwow.quickapi.domain.API;
import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIParameter;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import cn.schoolwow.quickapi.handler.APIEntityHandler;
import cn.schoolwow.quickapi.handler.AbstractHandler;
import cn.schoolwow.quickapi.handler.Handler;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public class APIParameterHandler
extends AbstractHandler {
    private Logger logger = LoggerFactory.getLogger(APIParameterHandler.class);

    public APIParameterHandler(QuickAPIOption option) {
        super(option);
    }

    @Override
    public Handler handle(APIDocument apiDocument) throws Exception {
        for (APIController apiController : apiDocument.apiControllerList) {
            for (API api : apiController.apiList) {
                this.getAPIParameter(api);
            }
        }
        return new APIEntityHandler(this.option);
    }

    private void getAPIParameter(API api) {
        LocalVariableTableParameterNameDiscoverer u = new LocalVariableTableParameterNameDiscoverer();
        String[] parameterRawNames = u.getParameterNames(api.method);
        ArrayList<APIParameter> apiParameterList = new ArrayList<APIParameter>();
        Parameter[] parameters = api.method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            APIParameter apiParameter = this.getByPathVariableAnnotation(api, parameter);
            if (null == apiParameter) {
                apiParameter = this.getByRequestParamAnnotation(api, parameter);
            }
            if (null == apiParameter) {
                apiParameter = this.getByRequestBodyAnnotation(api, parameter);
            }
            if (null == apiParameter) {
                apiParameter = this.getByRequestPartAnnotation(api, parameter);
            }
            if (null == apiParameter) {
                apiParameter = this.getByMultipartFile(api, parameter);
            }
            if (null != this.option.apiParameterFunction) {
                apiParameter = this.option.apiParameterFunction.apply(api, parameter);
            }
            if (null == apiParameter) {
                this.logger.debug("[\u4e0d\u652f\u6301\u5904\u7406\u8be5\u53c2\u6570]\u65b9\u6cd5\u540d:{},\u53c2\u6570\u540d:{}", (Object)api.method.getName(), (Object)parameter.getName());
                continue;
            }
            apiParameter.setName(apiParameter.annotationParameterName);
            apiParameter.setName(parameterRawNames[i]);
            apiParameter.parameterName = parameterRawNames[i];
            apiParameter.typeClassName = parameter.getType().getName();
            apiParameter.parameter = parameters[i];
            apiParameterList.add(apiParameter);
        }
        api.apiParameterList = apiParameterList;
    }

    private APIParameter getByPathVariableAnnotation(API api, Parameter parameter) {
        PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
        if (null == pathVariable) {
            return null;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.annotationParameterName = pathVariable.value();
        if (StringUtils.isEmpty((Object)apiParameter.annotationParameterName)) {
            apiParameter.annotationParameterName = pathVariable.name();
        }
        apiParameter.required = pathVariable.required();
        apiParameter.position = "path";
        return apiParameter;
    }

    private APIParameter getByRequestParamAnnotation(API api, Parameter parameter) {
        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        if (null == requestParam) {
            return null;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.annotationParameterName = requestParam.value();
        if (StringUtils.isEmpty((Object)apiParameter.annotationParameterName)) {
            apiParameter.annotationParameterName = requestParam.name();
        }
        if (!requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
            apiParameter.defaultValue = requestParam.defaultValue();
        }
        apiParameter.required = requestParam.required();
        apiParameter.position = "query";
        if ("POST".equalsIgnoreCase(api.requestMethod) || "PUT".equalsIgnoreCase(api.requestMethod) || "PATCH".equalsIgnoreCase(api.requestMethod)) {
            apiParameter.position = "body";
        }
        return apiParameter;
    }

    private APIParameter getByRequestPartAnnotation(API api, Parameter parameter) {
        RequestPart requestPart = parameter.getAnnotation(RequestPart.class);
        if (null == requestPart) {
            return null;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.annotationParameterName = requestPart.value();
        if (StringUtils.isEmpty((Object)apiParameter.annotationParameterName)) {
            apiParameter.annotationParameterName = requestPart.name();
        }
        apiParameter.required = requestPart.required();
        apiParameter.requestType = "file";
        api.contentType = "multipart/form-data";
        return apiParameter;
    }

    private APIParameter getByRequestBodyAnnotation(API api, Parameter parameter) {
        RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
        if (null == requestBody) {
            return null;
        }
        APIParameter apiParameter = new APIParameter();
        apiParameter.required = requestBody.required();
        apiParameter.position = "body";
        apiParameter.requestType = "textarea";
        api.contentType = "application/json";
        return apiParameter;
    }

    private APIParameter getByMultipartFile(API api, Parameter parameter) {
        String parameterTypeClassName;
        String multipartFileClassName = MultipartFile.class.getName();
        if (multipartFileClassName.equalsIgnoreCase(parameterTypeClassName = parameter.getType().getName()) || parameterTypeClassName.startsWith("[L") && parameterTypeClassName.contains(multipartFileClassName)) {
            APIParameter apiParameter = new APIParameter();
            apiParameter.position = "body";
            apiParameter.requestType = "file";
            api.contentType = "multipart/form-data";
            return apiParameter;
        }
        return null;
    }
}

