/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickapi.util;

import cn.schoolwow.quickapi.domain.APIController;
import cn.schoolwow.quickapi.domain.APIDocument;
import cn.schoolwow.quickapi.domain.APIEntity;
import cn.schoolwow.quickapi.domain.QuickAPIOption;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.javadoc.Main;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDocUtil {
    private static Logger logger = LoggerFactory.getLogger(JavaDocUtil.class);
    private static ClassDoc[] classDocs = new ClassDoc[0];

    public static ClassDoc[] getJavaDoc(APIDocument apiDocument, QuickAPIOption quickAPIOption) {
        URL[] urls;
        String packageName;
        ArrayList<String> packageNameList = new ArrayList<String>();
        for (APIController apiController : apiDocument.apiControllerList) {
            packageName = apiController.clazz.getPackage().getName();
            if (!packageNameList.stream().noneMatch(packageName1 -> packageName1.startsWith(packageName))) continue;
            packageNameList.add(packageName);
        }
        for (APIEntity apiEntity : apiDocument.apiEntityMap.values()) {
            packageName = apiEntity.clazz.getPackage().getName();
            if (!packageNameList.stream().noneMatch(packageName1 -> packageName1.startsWith(packageName))) continue;
            packageNameList.add(packageName);
        }
        if (packageNameList.isEmpty()) {
            throw new IllegalArgumentException("\u63a7\u5236\u5668\u7c7b\u5305\u540d\u5217\u8868\u4e3a\u7a7a!");
        }
        StringBuilder classPathBuilder = new StringBuilder();
        URLClassLoader urlClassLoader = new URLClassLoader(((URLClassLoader)ClassLoader.getSystemClassLoader()).getURLs());
        for (URL url : urls = urlClassLoader.getURLs()) {
            classPathBuilder.append(url.getPath().substring(1) + ";");
        }
        classPathBuilder.append(ClassLoader.getSystemClassLoader().getResource("").getPath().substring(1) + ";");
        ArrayList<String> commandList = new ArrayList<String>(Arrays.asList("-doclet", Doclet.class.getName(), "-encoding", "utf-8", "-private", "-quiet", "-classpath", classPathBuilder.toString(), "-sourcepath", quickAPIOption.sourcePath));
        Iterator iterator = packageNameList.iterator();
        while (iterator.hasNext()) {
            commandList.add("-subpackages");
            commandList.add((String)iterator.next());
        }
        logger.info("[\u8bfb\u53d6JavaDoc\u6ce8\u91ca]{}", commandList);
        Main.execute((String[])commandList.toArray(new String[0]));
        logger.info("[\u8bfb\u53d6\u7c7b\u6ce8\u91ca\u4e2a\u6570]{}", (Object)classDocs.length);
        return classDocs;
    }

    static /* synthetic */ ClassDoc[] access$002(ClassDoc[] x0) {
        classDocs = x0;
        return x0;
    }

    public static class Doclet {
        public static boolean start(RootDoc root) {
            JavaDocUtil.access$002(root.classes());
            return true;
        }
    }
}

