package cn.schoolwow.data.thread.config;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.quickflow.QuickFlow;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class QuickDataThreadConfig {
    private QuickFlow dataThreadFlow;

    public QuickDataThreadConfig(QuickFlow dataThreadFlow) {
        dataThreadFlow.putContextData("workDir", System.getProperty("java.io.tmpdir") + File.separator + "QuickDataThread");
        dataThreadFlow.putContextData("threadCount", Runtime.getRuntime().availableProcessors()*2);
        dataThreadFlow.putContextData("timeout", 1);
        dataThreadFlow.putContextData("timeoutUnit", TimeUnit.HOURS);
        dataThreadFlow.putContextData("progressList", new ArrayList<DataThreadProgress>());
        dataThreadFlow.putContextData("waitFor", true);
        dataThreadFlow.putContextData("recordProgress", true);
        this.dataThreadFlow = dataThreadFlow;
    }

    /**指定工作目录*/
    public QuickDataThreadConfig workDir(String workDir) throws IOException {
        Files.createDirectories(Paths.get(workDir));
        dataThreadFlow.putContextData("workDir", workDir);
        return this;
    }

    /**监听进度*/
    public QuickDataThreadConfig progressListener(ProgressListener progressListener) {
        dataThreadFlow.putContextData("progressListener", progressListener);
        return this;
    }

    /**线程个数*/
    public QuickDataThreadConfig threadCount(int threadCount) {
        dataThreadFlow.putContextData("threadCount", threadCount);
        return this;
    }

    /**等待超时时间*/
    public QuickDataThreadConfig timeout(Integer timeout, TimeUnit timeoutUnit) {
        dataThreadFlow.putContextData("timeout", timeout);
        dataThreadFlow.putContextData("timeoutUnit", timeoutUnit);
        return this;
    }

    /**是否等待线程执行完毕*/
    public QuickDataThreadConfig waitFor(boolean waitFor) {
        dataThreadFlow.putContextData("waitFor", waitFor);
        return this;
    }

    /**是否记录到进度列表*/
    public QuickDataThreadConfig recordProgress(boolean recordProgress) {
        dataThreadFlow.putContextData("recordProgress", recordProgress);
        return this;
    }

}
