package cn.schoolwow.data.thread.flow.common;

import cn.schoolwow.data.thread.exception.ThreadException;
import cn.schoolwow.data.thread.util.QuickDataThreadUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AfterExecuteFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        int timeout = (int) flowContext.checkData("timeout");
        TimeUnit timeoutUnit = (TimeUnit) flowContext.checkData("timeoutUnit");
        Map<Long,Exception> threadExceptionMap = (Map<Long, Exception>) flowContext.getData("threadExceptionMap", new HashMap<>());
        boolean waitFor = (boolean) flowContext.checkData("waitFor");

        threadPoolExecutor.shutdown();
        if(waitFor){
            threadPoolExecutor.awaitTermination(timeout, timeoutUnit);

            if(!threadExceptionMap.isEmpty()){
                throw new ThreadException(QuickDataThreadUtil.formatThreadException(threadExceptionMap), threadExceptionMap);
            }
        }
    }

    @Override
    public String name() {
        return "执行任务之后";
    }

}
