package cn.schoolwow.data.thread.flow.common;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

public class BeforeExecuteFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setDataThreadContextData(flowContext);
        setThreadPool(flowContext);
        setProcessListener(flowContext);
        setWaitFor(flowContext);
        setRecordProgress(flowContext);
        addToProgressList(flowContext);
        flowContext.putTemporaryData("threadExceptionMap", new HashMap<>());
        flowContext.putTemporaryData("progress", new AtomicInteger(1));
    }

    @Override
    public String name() {
        return "执行任务之前";
    }

    private void setDataThreadContextData(FlowContext flowContext){
        QuickFlow dataThreadFlow = (QuickFlow) flowContext.checkData("dataThreadFlow");

        Map<String, Object> contextDataMap = dataThreadFlow.getContextDataMap();
        for(Map.Entry<String,Object> entry:contextDataMap.entrySet()){
            flowContext.putContextData(entry.getKey(), entry.getValue());
        }
    }

    private void setThreadPool(FlowContext flowContext){
        Integer threadCount = (Integer) flowContext.getData("workThreadCount");
        if(null==threadCount){
            threadCount = (Integer) flowContext.getData("threadCount");
        }
        if(null==threadCount){
            threadCount = Runtime.getRuntime().availableProcessors()*2;
        }

        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) Executors.newFixedThreadPool(threadCount);
        flowContext.putCurrentCompositeFlowData("threadPoolExecutor", threadPoolExecutor);
    }

    private void setProcessListener(FlowContext flowContext){
        ProgressListener progressListener = (ProgressListener) flowContext.getData("workProgressListener");
        if(null==progressListener){
            progressListener = (ProgressListener) flowContext.getData("progressListener");
        }

        flowContext.putCurrentCompositeFlowData("progressListener", progressListener);
    }

    private void setWaitFor(FlowContext flowContext){
        Boolean waitFor = (Boolean) flowContext.getData("workWaitFor");
        if(null==waitFor){
            waitFor = (Boolean) flowContext.getData("waitFor");
        }
        flowContext.putCurrentCompositeFlowData("waitFor", waitFor);
    }

    private void setRecordProgress(FlowContext flowContext){
        Boolean recordProgress = (Boolean) flowContext.getData("workRecordProgress");
        if(null==recordProgress){
            recordProgress = (Boolean) flowContext.getData("recordProgress");
        }
        flowContext.putCurrentCompositeFlowData("recordProgress", recordProgress);
    }

    private void addToProgressList(FlowContext flowContext){
        List<DataThreadProgress> dataThreadProgressList = (List<DataThreadProgress>) flowContext.getData("progressList", new ArrayList<>());
        String name = (String) flowContext.checkData("name");
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        boolean recordProgress = (boolean) flowContext.checkData("recordProgress");

        DataThreadProgress dataThreadProgress = new DataThreadProgress();
        dataThreadProgress.id = System.nanoTime();
        dataThreadProgress.name = name;
        dataThreadProgress.startTime = new Timestamp(System.currentTimeMillis());
        dataThreadProgress.threadPoolExecutor = threadPoolExecutor;
        if(recordProgress){
            synchronized (dataThreadProgressList){
                dataThreadProgressList.add(dataThreadProgress);
            }
        }
        flowContext.putTemporaryData("dataThreadProgress", dataThreadProgress);
    }

}
