package cn.schoolwow.data.thread.flow.handler;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.data.thread.util.QuickDataThreadUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.FunctionFlow;
import cn.schoolwow.quickflow.listener.TryCatchFinallyHandler;

import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkTryCatchFinallyHandler implements TryCatchFinallyHandler {
    @Override
    public void handleTry(FlowContext flowContext) throws Exception {
        FunctionFlow handleFunction = (FunctionFlow) flowContext.checkData("handleFunction");
        handleFunction.executeFunction();
    }

    @Override
    public void handleException(FlowContext flowContext, Exception e) {
        Map<Long,Exception> threadExceptionMap = (Map<Long, Exception>) flowContext.getData("threadExceptionMap", new HashMap<>());
        synchronized (threadExceptionMap){
            threadExceptionMap.put(Thread.currentThread().getId(), e);
        }
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");
        dataThreadProgress.exception = QuickDataThreadUtil.formatThreadException(threadExceptionMap);
        dataThreadProgress.status = "异常结束";
    }

    @Override
    public void handleFinally(FlowContext flowContext) {
        String name = (String) flowContext.checkData("name");
        AtomicInteger progress = (AtomicInteger) flowContext.checkData("progress");
        int delta = (int) flowContext.checkData("delta");
        ProgressListener progressListener = (ProgressListener) flowContext.getData("progressListener");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");

        progress.getAndAdd(delta);
        if(null!=progressListener){
            progressListener.progress(name, progress.get(), dataThreadProgress.total);
        }
        dataThreadProgress.current = progress.get();
        dataThreadProgress.percent = dataThreadProgress.current*100/dataThreadProgress.total;
        if(dataThreadProgress.percent==100&&null==dataThreadProgress.exception){
            dataThreadProgress.endTime = new Timestamp(System.currentTimeMillis());
            dataThreadProgress.status = "正常结束";
        }
    }

    @Override
    public String name() {
        return "多线程任务tryCatchFinally处理器";
    }
}
