package cn.schoolwow.data.thread.flow.work;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.flow.handler.WorkTryCatchFinallyHandler;
import cn.schoolwow.data.thread.work.interval.IntervalDataThreadHandler;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecuteIntervalWorkFlow<T> implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        List<T> list = (List<T>) flowContext.checkData("list");
        int interval = (int) flowContext.checkData("interval");
        if(interval<=0){
            throw new IllegalArgumentException("任务间隔必须大于0");
        }
        IntervalDataThreadHandler<T> intervalDataThreadHandler = (IntervalDataThreadHandler<T>) flowContext.checkData("intervalDataThreadHandler");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");

        int segment = list.size()/interval+(list.size()%interval>0?1:0);
        dataThreadProgress.total = list.size();
        dataThreadProgress.type = "Interval";

        StringBuilder descriptionBuilder = new StringBuilder("分段列表:");
        for(int i=0;i<segment;i++){
            int start = i*interval;
            int end = Math.min((i+1)*interval, list.size());
            descriptionBuilder.append("["+start+"-"+end+"]");
            threadPoolExecutor.execute(new Runnable() {
                @Override
                public void run() {
                    flowContext.startFlow("执行Interval单个线程任务")
                            .tryCatchFinallyHandler(new WorkTryCatchFinallyHandler())
                            .putThreadLocalData("delta", end-start)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction() throws Exception {
                                    intervalDataThreadHandler.handleIntervalList(list, start, end);
                                }
                            })
                            .execute();
                }
            });
        }
        dataThreadProgress.description = descriptionBuilder.toString();
    }

    @Override
    public String name() {
        return "执行Interval类型任务";
    }
}
