package cn.schoolwow.data.thread.flow.work;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.flow.handler.WorkTryCatchFinallyHandler;
import cn.schoolwow.data.thread.work.loop.LoopDataThreadHandler;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.concurrent.ThreadPoolExecutor;

public class ExecuteLoopWorkFlow<T> implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        int startIndex = (int) flowContext.checkData("startIndex");
        int endIndex = (int) flowContext.checkData("endIndex");
        LoopDataThreadHandler loopDataThreadHandler = (LoopDataThreadHandler) flowContext.checkData("loopDataThreadHandler");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");

        dataThreadProgress.total = endIndex-startIndex+1;
        dataThreadProgress.type = "Loop";

        for(int i=startIndex;i<endIndex;i++){
            int currentIndex = i;
            threadPoolExecutor.execute(new Runnable() {
                @Override
                public void run() {
                    flowContext.startFlow("执行Loop单个线程任务")
                            .tryCatchFinallyHandler(new WorkTryCatchFinallyHandler())
                            .putThreadLocalData("delta", 1)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction() throws Exception {
                                    loopDataThreadHandler.handleLoop(currentIndex);
                                }
                            })
                            .execute();
                }
            });
        }
    }

    @Override
    public String name() {
        return "执行Loop类型任务";
    }
}
