package cn.schoolwow.data.thread.flow.work;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.flow.handler.WorkTryCatchFinallyHandler;
import cn.schoolwow.data.thread.flow.work.map.GetMapFileFlow;
import cn.schoolwow.data.thread.work.map.MapFile;
import cn.schoolwow.data.thread.work.map.MapWorkResult;
import cn.schoolwow.data.thread.work.reduce.ReduceDataThreadHandler;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecuteReduceWorkFlow<T> implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        ReduceDataThreadHandler reduceDataThreadHandler = (ReduceDataThreadHandler) flowContext.checkData("reduceDataThreadHandler");
        MapWorkResult mapWorkResult = (MapWorkResult) flowContext.checkData("mapWorkResult");
        boolean deleteFile = (boolean) flowContext.getData("deleteFile", true);
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");

        dataThreadProgress.total = mapWorkResult.idList.size();
        dataThreadProgress.type = "Reduce";
        dataThreadProgress.description = "id列表:"+mapWorkResult.idList;

        final List<String> idList = new ArrayList<>();
        flowContext.putTemporaryData("idList", idList);

        for(String id:mapWorkResult.idList){
            threadPoolExecutor.execute(()->{
                flowContext.startFlow("执行Reduce单个线程任务")
                        .tryCatchFinallyHandler(new WorkTryCatchFinallyHandler())
                        .putThreadLocalData("delta", 1)
                        .putThreadLocalData("handleFunction", new FunctionFlow() {
                            @Override
                            public void executeFunction() throws Exception {
                                File file = (File) flowContext.startFlow(new GetMapFileFlow())
                                        .putThreadLocalData("workName", mapWorkResult.name)
                                        .putThreadLocalData("id", id)
                                        .execute()
                                        .checkData("mapFile");
                                String content = FileUtils.readFileToString(file, "UTF-8");
                                MapFile mapFile = new MapFile();
                                mapFile.id = id;
                                mapFile.content = content;
                                reduceDataThreadHandler.reduce(mapFile, file);
                                if(deleteFile){
                                    FileUtils.forceDelete(file);
                                    flowContext.putTemporaryDataIfAbsent("mapDirectory", file.getParent());
                                }
                            }
                        })
                        .execute();
            });
        }
    }

    @Override
    public String name() {
        return "执行Reduce类型任务";
    }

}
