package cn.schoolwow.data.thread.flow.work;

import cn.schoolwow.data.thread.domain.DataThreadProgress;
import cn.schoolwow.data.thread.flow.handler.WorkTryCatchFinallyHandler;
import cn.schoolwow.data.thread.work.single.SingleDataThreadHandler;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.FunctionFlow;

import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

public class ExecuteSingleWorkFlow<T> implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor) flowContext.checkData("threadPoolExecutor");
        List<T> list = (List<T>) flowContext.checkData("list");
        SingleDataThreadHandler<T> singleDataThreadHandler = (SingleDataThreadHandler<T>) flowContext.checkData("singleDataThreadHandler");
        DataThreadProgress dataThreadProgress = (DataThreadProgress) flowContext.checkData("dataThreadProgress");

        dataThreadProgress.total = list.size();
        dataThreadProgress.type = "Single";

        for(int i=0;i<list.size();i++){
            int index = i;
            threadPoolExecutor.execute(new Runnable() {
                @Override
                public void run() {
                    flowContext.startFlow("执行Single单个线程任务")
                            .tryCatchFinallyHandler(new WorkTryCatchFinallyHandler())
                            .putThreadLocalData("delta", 1)
                            .putThreadLocalData("handleFunction", new FunctionFlow() {
                                @Override
                                public void executeFunction() throws Exception {
                                    singleDataThreadHandler.handleSingleList(list.get(index));
                                }
                            })
                            .execute();
                }
            });
        }
    }

    @Override
    public String name() {
        return "执行Single类型任务";
    }
}
