package cn.schoolwow.data.thread.flow.work.map;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.io.File;
import java.nio.file.Paths;

public class GetMapFileFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String workDir = (String) flowContext.checkData("workDir");
        String workName = (String) flowContext.checkData("workName");
        String id = (String) flowContext.checkData("id");

        File mapFile = Paths.get(workDir).resolve(workName).resolve("map-"+workName+"-"+id+".txt").toFile();
        flowContext.putThreadLocalData("mapFile", mapFile);
    }

    @Override
    public String name() {
        return "判断map文件是否存在";
    }
}
