package cn.schoolwow.data.thread.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public class QuickDataThreadUtil {
    public static String formatThreadException(Map<Long,Exception> threadIdExceptionMap){
        StringBuilder builder = new StringBuilder("线程异常:\r\n");
        for(Map.Entry<Long,Exception> entry:threadIdExceptionMap.entrySet()){
            builder.append(entry.getKey()+":"+entry.getValue().getMessage()+"\r\n");
        }
        //仅显示第一个异常的详细堆栈信息
        builder.append("堆栈信息\r\n");
        Exception firstException = threadIdExceptionMap.values().iterator().next();
        builder.append(exception2String(firstException)+"\r\n");
        return builder.toString();
    }

    public static String exception2String(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

}
