package cn.schoolwow.data.thread.work;

import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.quickflow.QuickFlow;

public abstract class AbstractDataThreadWork<T extends AbstractDataThreadWork<T>> implements DataThreadWork{
    protected QuickFlow workFlow = QuickFlow.newInstance();

    public AbstractDataThreadWork(String name){
        workFlow.putContextData("name", name);
    }

    /**监听进度*/
    public T progressListener(ProgressListener progressListener) {
        workFlow.putContextData("workProgressListener", progressListener);
        return self();
    }

    /**线程个数*/
    public T threadCount(int threadCount) {
        workFlow.putContextData("workThreadCount", threadCount);
        return self();
    }

    /**是否等待线程执行完毕*/
    public T waitFor(boolean waitFor) {
        workFlow.putContextData("workWaitFor", waitFor);
        return self();
    }

    /**是否记录到进度列表*/
    public T recordProgress(boolean recordProgress) {
        workFlow.putContextData("workRecordProgress", recordProgress);
        return self();
    }

    public QuickFlow getWorkFlow(){
        return workFlow;
    }

    protected abstract T self();
}
