package cn.schoolwow.data.thread.work.interval;

import cn.schoolwow.data.thread.work.AbstractDataThreadWork;

import java.util.List;

public class IntervalDataThreadWork extends AbstractDataThreadWork<IntervalDataThreadWork> {

    public IntervalDataThreadWork(String name) {
        super(name);
    }

    @Override
    protected IntervalDataThreadWork self() {
        return this;
    }

    /**数据列表*/
    public <T> IntervalDataThreadWork list(List<T> list){
        workFlow.putContextData("list", list);
        return this;
    }

    /**数据间隔*/
    public IntervalDataThreadWork interval(int interval){
        workFlow.putContextData("interval", interval);
        return this;
    }

    /**处理器*/
    public <T> IntervalDataThreadWork intervalDataThreadHandler(IntervalDataThreadHandler<T> intervalDataThreadHandler){
        workFlow.putContextData("intervalDataThreadHandler", intervalDataThreadHandler);
        return this;
    }

}
